//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//       
//
//                
//
//      :
//                        0=<x<=1,
//      dy1/dx = y2
//      dy2/dx = S0*[(S1+S2)*y1 - S2*y3 - Q*f(y1)*y4]
//      dy3/dx = S2*(y1 - y3)
//      dy4/dx = -S3*f(y1)*y4
//    
//      f(y1) = 1/[S5 + exp(-(y1 + S4)/(1 + S6*(y1 + S4)]
//      :
//           y2(0) = y3(0) = 0, y4(0) = 1
//           y2(1) = 0
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

library Special;

uses Math;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;

const
  PI = 3.14159265;

var
  S0, S1, S2, S3, S4, S5, S6
  : Double;


//============================================================================= RENAM
procedure RENAM(SPar: TD);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  S0 := SPar[1]
  S1 := SPar[2];
  S2 := SPar[3];
  S3 := SPar[4];
  S4 := SPar[5];
  S5 := SPar[6];
  S6 := SPar[7];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BOND
procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;
var
  I, J: Integer;
begin
  for I := 1 to NDIM do
    for J := 1 to N2 + 1 do
      G[I, J] := 0.;
  //--------------------------------------------------------------- Spec_begin
  G[1, 10] := V[1, 2];
  G[2, 10] := V[1, 3];
  G[3, 10] := V[1, 4] - 1;
  G[4, 10] := V[N5, 2];
  G[1, 2] := 1;
  G[2, 3] := 1;
  G[3, 4] := 1;
  G[4, 6] := 1;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTB
procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;
//----------------------------------------------------------------- Spec_begin
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  case LN_ of
    1:   GG := Z[2];
    2:   GG := Z[3];
    3:   GG := Z[4] - 1;
    4:   GG := Z[6];
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= JACOB
procedure JACOB(NDIM: Integer;   D, QMOD: Double;   Q: TD;
                var O,R: TD;   var U: TV);   Export;
var
  I, J: Integer;
  //--------------------------------------------------------------- Spec_begin
  EE, WR, DW: Double;
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to NDIM do
  begin
    for J := 1 to NDIM + 1 do
      U[I, J] := 0.;
    R[I] := 0.;
  end;   //   I
  //--------------------------------------------------------------- Spec_begin
  EE := EXP(-(Q[1] + S4) / (1 + S6 * (Q[1] + S4)));
  WR := 1 / (S5 + EE);
  DW := EE * sqr(WR) / sqr((1 + S6 * (Q[1] + S4)));
  O[1] := Q[2];
  O[2] := S0 * ((S1 + S2) * Q[1] - S2 * Q[3] - QMOD * Q[4] * WR);
  O[3] := S2 * (Q[1] - Q[3]);
  O[4] := -S3 * Q[4] * WR;
  U[1, 2] := 1;
  U[2, 1] := S0 * (S1 + S2 - QMOD * Q[4] * DW);
  U[2, 3] := -S0 * S2;
  U[2, 4] := -S0 * QMOD * WR;
  R[2] := -S0 * Q[4] * WR;
  U[3, 1] := S2;
  U[3, 3] := -S2;
  U[4, 1] := -S3 * Q[4] * DW;
  U[4, 4] := -S3 * WR;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTJ
procedure LISTJ(LN_: Integer;   D, QMOD: Double;   Z: TD;   var FF: Double);   Export;
var
  WR: Double;
begin
  //--------------------------------------------------------------- Spec_begin
  WR := 1 / (S5 + EXP(-(Z[1] + S4) / (1 + S6 * (Z[1] + S4))));
  Case LN_ Of
    1:    FF := Z[2];
    2:    FF := S0 * ((S1 + S2) * Z[1] - S2 * Z[3] - Z[5] * Z[4] * WR);
    3:    FF := S2 * (Z[1] - Z[3]);
    4:    FF := -S3 * Z[4] * WR;
  end;
  //--------------------------------------------------------------- Spec_end
end;



//============================================================================= BIFC
procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;
               var BFX, BF1, BF2: TD);   Export;
//----------------------------------------------------------------- Spec_begin
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  BFX[ISTEP + 1] := QMOD;
  BF1[ISTEP + 1] := V[N5, NKC[1]];
  BF2[ISTEP + 1] := V[N5, NKC[2]];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= INAPP
procedure INAPP(N5, NDIM, INAP: Integer;   var D : TD;   var V: TV);   Export;
var
  I : Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  if INAP = 3 then       //Non-standard setting of a grid D[I]:
  begin
    //------------------------------------------------------------- Spec_begin
    D[1]  := 0;
    // ...
    D[N5] := 1;
    //------------------------------------------------------------- Spec_end
  end;

  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:
  begin
    //------------------------------------------------------------- Spec_begin
    V[I, 1]    := 0;
    // ...
    V[I, NDIM] := 0;
    //------------------------------------------------------------- Spec_end
  end;
end;


//============================================================================= ADFUN
procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;
var
  I: Integer;
  //--------------------------------------------------------------- Spec_begin
  Z0,EE,WR: Double;
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to N5 do
  begin
    //------------------------------------------------------------- Spec_begin
    Z0 := 1. / (1. + S6 * (S4 + abs(V[I,1])));
    EE := exp(-(S4 + abs(V[I,1])) * Z0);
    WR := 1. / (S5 + EE);
    WD[I,1] := QMOD * WR * V[I,4];
    //------------------------------------------------------------- Spec_end
  end;
end;


Exports
  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;


begin
end.
