//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//               
//
//               
//                     Luss' 
//        s0, s1, s2  s3:
//                       0=<x<=1,
//    dy1/dx = y2 
//    dy2/dx = -s0*y2/t - s3*(s2 - y1)*exp(y1/(1 + s1*y1)
//            
//     :
//                y2(0) = 0,  y1(1) = 0
//
//              s3 -   
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

library Special;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;
  //--------------------------------------------------------------- Spec_begin
var
  S0, S1, S2, S3
  : Double;
  //--------------------------------------------------------------- Spec_end


//============================================================================= RENAM
procedure RENAM(SPar: TD);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  S0 := SPar[1];
  S1 := SPar[2];
  S2 := SPar[3];
  S3 := SPar[4];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BOND
procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;
var
  I, J: Integer;
begin
  for I := 1 to NDIM do
    for J := 1 to N2 + 1 do
      G[I, J] := 0.;
  //--------------------------------------------------------------- Spec_begin
  G[1,2] := 1.;   G[1,N2+2] := V[1,2]; 
  G[2,3] := 1.;   G[2,N2+2] := V[N5,1];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTB
procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  case LN_ of
    1:   GG := Z[2];
    2:   GG := z[3];
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= JACOB
procedure JACOB(NDIM: Integer;   D, QMOD: Double;   Q: TD;
                var O,R: TD;   var U: TV);   Export;
var
  I, J: Integer;
  //--------------------------------------------------------------- Spec_begin
  Z0, EE: Double;
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to NDIM do
  begin
    for J := 1 to NDIM + 1 do
      U[I, J] := 0.;
    R[I] := 0.;
  end;   //   I
  //--------------------------------------------------------------- Spec_begin
  S3 := QMOD;
  Z0 := 1 / (1 + S1 * Q[1]);
  EE := EXP(Q[1] * Z0);
  O[1] := Q[2];
  U[1,2] := 1E0;
  if D > 0.0001 then
  begin
    R[2] := -(S2 - Q[1]) * EE;
    U[2, 2] := -S0 / D;
    O[2] := U[2, 2] * Q[2] + S3 * R[2];
    U[2, 1] := S3 * EE * (1 - (S2 - Q[1]) * Z0 * Z0);
    U[2, 3] := S3 * Q[2] / D / D;
  end
  else
  begin
    R[2] := -(S2 - Q[1]) * EE / (S0 + 1);
    U[2, 2] := 0;
    U[2, 3] := 0;
    O[2] := S3 * R[2];
    U[2, 1] := S3 * (1 - (S2 - Q[1]) * Z0 * Z0) * EE / (S0 + 1);
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTJ
procedure LISTJ(LN_: Integer;   D, QMOD: Double;   Z: TD;   var FF: Double);   Export;
//----------------------------------------------------------------- Spec_begin
var
  Z0, EE: Double;
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  S3 := Z[3];
  case LN_ of
    1:   FF := Z[2];
    2:
    begin
      Z0 := 1 / (1 + S1 * Z[1]);    EE := exp(Z[1] * Z0);
      if D > 0.000001 THEN
	FF := -S0 * Z[2] / D - S3 * (S2 - Z[1]) * EE
      else
	FF := -S3 * (S2 - Z[1]) * EE / (S0 + 1);
    end;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BIFC
procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;
               var BFX, BF1, BF2: TD);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  BFX[IStep+1] := QMOD;
  BF1[IStep+1] := V[1, NKC[1]];
  BF2[IStep+1] := Ln(-(S0 + 1) * V[N5, NKC[2]] / QMOD / S2);
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= INAPP
procedure INAPP(N5, NDIM, INAP: Integer;   var D : TD;   var V: TV);   Export;
var
  I : Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  if INAP = 3 then       //Non-standard setting of a grid D[I]:
  begin
    //------------------------------------------------------------- Spec_begin
    D[1]  := 0;
    // ...
    D[N5] := 1;
    //------------------------------------------------------------- Spec_end
  end;

  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:
  begin
    //------------------------------------------------------------- Spec_begin
    V[I, 1]    := 0;
    // ...
    V[I, NDIM] := 0;
    //------------------------------------------------------------- Spec_end
  end;
end;


//============================================================================= ADFUN
procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;
var
  I: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to N5 do
  begin
    //------------------------------------------------------------- Spec_begin
    WD[I, 1] := 2 * V[I, 1];
    //------------------------------------------------------------- Spec_end
  end;
end;


Exports
  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;


begin
end.
