//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                                                              
//                   -
//      
//                   
//      
//           :
//                            0=<t<=1,
//                  dy1/dt = y2 
//                  dy2/dt = Qs*y1*(1 -y2)/s0 
//                  
//            :
//                  y1(0) = s1,  y1(1) = s2
//      
//          : s0, s1, s2, Qs
//                     Qs -   
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

library Special;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;
  //--------------------------------------------------------------- Spec_begin
var
  s0, s1, s2, Qs
  : Double;
  //--------------------------------------------------------------- Spec_end


//============================================================================= RENAM
procedure RENAM(SPar: TD);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  s0 := SPar[1];
  s1 := SPar[2];
  s2 := SPar[3];
  Qs := SPar[4];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BOND
procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;
var
  I, J: Integer;
begin
  for I := 1 to NDIM do
    for J := 1 to N2 + 1 do
      G[I, J] := 0.;
  //--------------------------------------------------------------- Spec_begin
  G[1, 6] := V[1, 1] - s1;
  G[2, 6] := V[N5, 1] - s2;
  G[1, 1] := 1;
  G[2, 3] := 1;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTB
procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  case LN_ of
    1:   GG := Z[2];
    2:   GG := Z[3];
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= JACOB
procedure JACOB(NDIM: Integer;   D, QMOD: Double;   Q: TD;
                var O,R: TD;   var U: TV);   Export;
var
  I, J: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to NDIM do
  begin
    for J := 1 to NDIM + 1 do
      U[I, J] := 0.;
    R[I] := 0.;
  end;   //   I
  //--------------------------------------------------------------- Spec_begin
  Qs := QMOD;
  O[1] := Q[2];
    U[1, 2] := 1;
  O[2] := Qs * Q[1] * (1 - Q[2]) / s0;
    U[2, 1] := Qs * (1 - Q[2]) / s0;
    U[2, 2] := -Qs * Q[1] / s0;
    R[2] := Q[1] * (1 - Q[2]) / s0;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTJ
procedure LISTJ(LN_: Integer;   D: Double;   Z: TD;   var FF: Double);   Export;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  Case LN_ Of
    1:   FF := 0;
    2:   FF := 0;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BIFC
procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;
               var BFX, BF1, BF2: TD);   Export;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  BFX[ISTEP + 1] := QMOD;
  BF1[ISTEP + 1] := V[1, 2];
  BF2[ISTEP + 1] := V[N5, 2];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= INAPP
procedure INAPP(N5, NDIM, INAP: Integer;   D : TD;   var V: TV);   Export;
var
  I : Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  if INAP = 3 then       //Non-standard setting of a grid D[I]:
  begin
    //------------------------------------------------------------- Spec_begin
    D[1]  := 0;
    // ...
    D[N5] := 1;
    //------------------------------------------------------------- Spec_end
  end;

  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:
  begin
    //------------------------------------------------------------- Spec_begin
    V[I, 1]    := 0;
    // ...
    V[I, NDIM] := 0;
    //------------------------------------------------------------- Spec_end
  end;
end;


//============================================================================= ADFUN
procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;
var
  I: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to N5 do
  begin
    //------------------------------------------------------------- Spec_begin
    WD[I, 1] := 2 * V[I, 1];
    //------------------------------------------------------------- Spec_end
  end;
end;


Exports
  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;


begin
end.
