//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                                                              
//        MODEL of Platform
//                                                                              
//              Wording of the boundary problem
//
//    System of the equations:
//                                   0<=x<=1
//                dy1/dx = y2
//                dy2/dx = -S2*y2 - S0*y1 * S1*[cos(PI*x)/(1-y1)]^2
//
//    Boundary conditions:
//                         y1(0) = y1(1), y2(0)=y2(1)
//
//    Parameters: S0, S1, S2;    S1 - parameter of the continuation
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

library Special;

uses 
  Math;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;

const
  PI  = 3.14159265358979;    

var
  S0, S1, S2
  : Double;


//============================================================================= RENAM
procedure RENAM(SPar: TD);   Export;
begin
  //------------------------------------------------------------- Spec_begin
  S0 := SPar[1];
  S1 := SPar[2];
  S2 := SPar[3];
  //------------------------------------------------------------- Spec_end
end;


//============================================================================= BOND
procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;
var
  I, J: Integer;
begin
  for I := 1 to NDIM do
    for J := 1 to N2 + 1 do
      G[I, J] := 0.;
  //------------------------------------------------------------- Spec_begin
  G[1, 6] := V[1, 1] - V[N5, 1];
  G[2, 6] := V[1, 2] - V[N5, 2];
  G[1, 1] := 1;
  G[1, 3] := -1;
  G[2, 2] := 1;
  G[2, 4] := -1; 
  //------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTB
procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;
//--------------------------------------------------------------- Spec_begin
//--------------------------------------------------------------- Spec_end
begin
  //------------------------------------------------------------- Spec_begin
  //------------------------------------------------------------- Spec_end
end;


//============================================================================= JACOB
procedure JACOB(NDIM: Integer;   DD, QMOD: Double;   Q: TD;
                var O,R: TD;   var U: TV);   Export;
var
  I, J: Integer;
  //------------------------------------------------------------- Spec_begin
  WR, DW, TW: Double;
  //------------------------------------------------------------- Spec_end
begin
  for I := 1 to NDIM do
  begin
    for J := 1 to NDIM + 1 do
      U[I, J] := 0.;
    R[I] := 0.;
  end;   //   I
  //------------------------------------------------------------- Spec_begin
  S1 := QMOD;
  WR := sqr(cos(PI * DD)/(1 - Q[1]));
  DW := 2 * WR / (1 - Q[1]);
  TW := -PI * sin(2 * PI * DD)/sqr(1 - Q[1]);  
  O[1] := Q[2];
  O[2] := -S2 * Q[2] - S0 * Q[1] + S1 * WR;
  U[1, 2] := 1;
  U[2, 1] := -S0 + S1 * DW;
  U[2, 2] := - S2; 
  U[2, 3] := S1 * TW;
  R[2] := WR;
  //------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTJ
procedure LISTJ(LN_: Integer;   DD, QMOD: Double;   Z: TD;   var FF: Double);   Export;
//--------------------------------------------------------------- Spec_begin
//--------------------------------------------------------------- Spec_end
begin
  //------------------------------------------------------------- Spec_begin
  Case LN_ Of
    1:   FF := 0;
    2:   FF := 0;
  end;
  //------------------------------------------------------------- Spec_end
end;


//============================================================================= BIFC
procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;
               var BFX, BF1, BF2: TD);   Export;
//--------------------------------------------------------------- Spec_begin
//--------------------------------------------------------------- Spec_end
begin
  //------------------------------------------------------------- Spec_begin
  BFX[ISTEP + 1] := QMOD;
  BF1[ISTEP + 1] := V[1, 1];
  BF2[ISTEP + 1] := V[2, 1];
  //------------------------------------------------------------- Spec_end
end;


//============================================================================= INAPP
procedure INAPP(N5, NDIM, INAP: Integer;   var D : TD;   var V: TV);   Export;
var
  I : Integer;
  //------------------------------------------------------------- Spec_begin
  PI1, PI2, Z1, Z2 : Double; 
  //------------------------------------------------------------- Spec_end
begin
  if INAP = 3 then       //Non-standard setting of a grid D[I]:    
  begin              
    //----------------------------------------------------------- Spec_begin
    D[1]    := 0;
    // ...
    D[NDIM] := 0;
    //----------------------------------------------------------- Spec_end
  end;

  PI1 := 4*PI*PI;    PI2 := 2*PI;    Z1 := S0 - PI1;
  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:
  begin
    //----------------------------------------------------------- Spec_begin
    Z2 := PI2 * D[I];
    V[I, 1] := 0.5 * S1 * (1 / S0 + cos(Z2)) / z1;
    V[I, 2] := -PI * S1 *           sin(Z2)  / Z1;
    //----------------------------------------------------------- Spec_end
  end;
end;


//============================================================================= ADFUN
procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;
var
  I: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to N5 do
  begin
    //------------------------------------------------------------- Spec_begin
    WD[I, 1] := 2 * V[I, 1];
    //------------------------------------------------------------- Spec_end
  end;
end;


Exports
  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;


begin
end.
