unit Start;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Grids, ToolWin, ExtCtrls, ImgList, Menus;

type
  TForm2 = class(TForm)
    StatusBar2: TStatusBar;
    PageControl_SC: TPageControl;
    TabSheet3: TTabSheet;
    Panel1_Main: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Image1: TImage;
    ToolBar1: TToolBar;
    tbb_Main_Help: TToolButton;
    ToolButton2: TToolButton;
    tbb_Main_Exit: TToolButton;
    TabSheet4: TTabSheet;
    ToolBar2: TToolBar;
    tbb_Equa_Read: TToolButton;
    ToolButton1: TToolButton;
    tbb_Equa_Save: TToolButton;
    ToolButton6: TToolButton;
    tbb_Equa_Cmpl: TToolButton;
    ToolButton7: TToolButton;
    tbb_Equa_Del: TToolButton;
    ToolButton4: TToolButton;
    tbb_Equa_Help: TToolButton;
    ToolButton3: TToolButton;
    tbb_Equa_Exit: TToolButton;
    Panel_ReaM: TPanel;
    Label1: TLabel;
    Label37: TLabel;
    Label39: TLabel;
    cb_Equa: TComboBox;
    Memo_Equa: TMemo;
    Panel5_ParName: TPanel;
    Label36: TLabel;
    StringGrid_ParNam: TStringGrid;
    Button1_OK: TButton;
    ed_NDIM: TEdit;
    ed_NPAR: TEdit;
    ImageList1: TImageList;
    tbb_Equa_Work: TToolButton;
    ToolButton8: TToolButton;
    ed_NMAX: TEdit;
    Label2: TLabel;
    ed_NBIF: TEdit;
    Label3: TLabel;
    pum_Cr_Re: TPopupMenu;
    pum_Temp1: TMenuItem;
    pum_Cr_He1: TPopupMenu;
    Delphi1: TMenuItem;
    Problem1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    PopupMenu1: TPopupMenu;
    ddb_Save_Dim: TMenuItem;
    tb_Equa_Clear: TToolButton;
    ToolButton9: TToolButton;
    pm_EquaClear: TPopupMenu;
    Allclear1: TMenuItem;
    procedure Problem1Click(Sender: TObject);
    procedure Delphi1Click(Sender: TObject);
    procedure tb_Equa_ClearClick(Sender: TObject);
//    procedure tb_Equa_ClearClick(Sender: TObject);
    procedure Allclear1Click(Sender: TObject);
//    procedure ToolBar2Click(Sender: TObject);
    procedure ddb_Save_DimClick(Sender: TObject);
//    procedure pum_Clear2Click(Sender: TObject);
//    procedure pum_Clear1Click(Sender: TObject);
    procedure Button1_OKClick(Sender: TObject);
    procedure pum_Temp1Click(Sender: TObject);
    procedure cb_EquaSelect(Sender: TObject);
    procedure cb_EquaKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Memo_EquaMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Memo_EquaMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Memo_EquaKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Memo_EquaKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure tbb_Equa_ExitClick(Sender: TObject);
    procedure tbb_Equa_HelpClick(Sender: TObject);
    procedure tbb_Equa_DelClick(Sender: TObject);
    procedure tbb_Equa_CmplClick(Sender: TObject);
    procedure tbb_Equa_SaveClick(Sender: TObject);
    procedure tbb_Equa_ReadClick(Sender: TObject);
    procedure tbb_Equa_WorkClick(Sender: TObject);
    procedure tbb_Main_ExitClick(Sender: TObject);
    procedure tbb_Main_HelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

uses UMain, UProced, UGlobal, Unit3;

{$R *.dfm}

//------------------------------------------------------------------------------------------------------------ FormCreate
procedure TForm2.FormCreate(Sender: TObject);
begin
  //ShowMessage('TForm2.FormCreate');
  cb_Equa.ItemIndex := 0;       //       

  CurDir := GetCurrentDir;        //ShowMessage('CurDir = ' + CurDir);

  Refresh_();

  PageControl_SC.TabIndex := 0;

  tbb_Equa_Work.Enabled := False;
  tbb_Equa_Read.Enabled := False;
  tbb_Equa_Save.Enabled := False;
  tbb_Equa_Cmpl.Enabled := False;
  //tbb_Calc_Run.Enabled  := False;

  with StatusBar2 do    begin
    Panels[6].Text := DateToStr(Date);    Panels[7].Text := TimeToStr(Time);    end;
end;


//------------------------------------------------------------------------------------------------------------ ComboBox1Select
procedure TForm2.cb_EquaSelect(Sender: TObject);
//       -     'cb_Equa'.
begin
  ComboBox1_Select();    //ShowMessage('ModelName = ' + ModelName);
  tbb_Equa_Read.Enabled := True;
end;

//------------------------------------------------------------------------------------------------------------ tbb_Main
procedure TForm2.tbb_Main_HelpClick(Sender: TObject);
begin
  winhelp(Form1.Handle,'BPRQ_Help.hlp', HELP_CONTEXT, 4);
end;

procedure TForm2.tbb_Main_ExitClick(Sender: TObject);
begin
  Close;
end;

//------------------------------------------------------------------------------------------------------------ tbb_Equa
procedure TForm2.tbb_Equa_WorkClick(Sender: TObject);
begin
  NDIM := StrToInt(ed_NDIM.Text);      //ShowMessage('NDIM     = ' + IntToStr(NDIM));
  NPAR := StrToInt(ed_NPAR.Text);      //ShowMessage('NPAR     = ' + IntToStr(NPAR));
  NMAX := StrToInt(ed_NMAX.Text);      //ShowMessage('NMAX     = ' + IntToStr(NMAX));
  NBIF := StrToInt(ed_NBIF.Text);      //ShowMessage('NBIF     = ' + IntToStr(NBIF));
  SetLengthMass();
  Form1.Show;
end;

//.............................................................................................................. < Line:
    //<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    procedure Memo_Line_N();
    begin
      Form2.StatusBar2.Panels[1].Text := IntToStr(Form2.Memo_Equa.CaretPos.Y+1) + ' : ' + IntToStr(Form2.Memo_Equa.CaretPos.X+1);
    end;
    //>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

//.......................................................................................... KeyDown:
procedure TForm2.Memo_EquaKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin    Memo_Line_N();    end;

//.......................................................................................... KeyUp:
procedure TForm2.Memo_EquaKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin    Memo_Line_N();    end;

//.......................................................................................... MouseDown:
procedure TForm2.Memo_EquaMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin    Memo_Line_N();    end;

//.......................................................................................... MouseUp:
procedure TForm2.Memo_EquaMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin    Memo_Line_N();    end;


procedure TForm2.Delphi1Click(Sender: TObject);
begin
  winhelp(Form1.Handle,'Delphi.hlp', HELP_CONTEXT, 1);
end;

procedure TForm2.Problem1Click(Sender: TObject);
begin
  winhelp(Form1.Handle,'Probl.hlp', HELP_CONTEXT, 1);
end;

//.............................................................................................................. > Line:


//------------------------------------------------------------------- cb_EquaKeyDown
procedure TForm2.cb_EquaKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
//     -   'ENTER'   'cb_Equa'.
//     'ENTER'   'cb_Equa'   'ModelName'.
//      3 : 1) - Equa, 2) - NDIM, 3) - NPAR
var
  I, Num : Integer;    E : Double;
begin
  if (Key = 13) then    //'ENTER'
  begin
    if cb_Equa.Text = '' then    begin
      ShowMessage('Set a  Model Name, press  "ENTER"  and try once again');    Exit;    end;

    ModelName := cb_Equa.Text;    ShowMessage('ModelName = ' + ModelName);
    //  ( ,    !)
    {ed_NDIM.Text := '3';    ed_NPAR.Text := '3';    ed_NMAX.Text := '100';    ed_NBIF.Text := '1000';}
    if DirectoryExists(ModelName) then
    begin
      ShowMessage('Directory  "' + ModelName + '"  already exists.');    // + #10#13 + 'Set other name');    //Exit;
    end;
    tbb_Equa_Read.Enabled := True;    //  - ,     
  end;
end;

//------------------------------------------------------------------- pum_Temp1
procedure TForm2.pum_Temp1Click(Sender: TObject);
var
  I : Integer;
begin    //ShowMessage('Temp1');     //   2 : NDIM  NPAR:
  NDIM := StrToInt(ed_NDIM.Text);    //ShowMessage('NDIM = ' + IntToStr(NDIM));
  NPAR := StrToInt(ed_NPAR.Text);    //ShowMessage('NPAR = ' + IntToStr(NPAR));
  NMAX := StrToInt(ed_NMAX.Text);    //ShowMessage('NMAX = ' + IntToStr(NMAX));
  NBIF := StrToInt(ed_NBIF.Text);    //ShowMessage('NBIF = ' + IntToStr(NBIF));
  NPAR_div := NPAR div 10;           //ShowMessage('NPAR_div = ' + IntToStr(NPAR_div));
  NPAR_mod := NPAR mod 10;           //ShowMessage('NPAR_mod = ' + IntToStr(NPAR_mod));}

  Panel5_ParName.Visible := True;    SetLength(Par_Name, NPAR + 1);
  with StringGrid_ParNam do
  begin
    RowCount := NPAR + 1;    Cells[0, 0] := '#';    Cells[1, 0] := 'Name';
    for I := 1 to NPAR do    begin
      Cells[0, I] := IntToStr(I);    Cells[1, I] := 'SP' + IntToStr(I);    end;
    end;
    Button1_OK.SetFocus;
end;

//------------------------------------------------------------------- Button1_OK
procedure TForm2.Button1_OKClick(Sender: TObject);
var
  I : Integer;
begin
  for I := 1 to NPAR do
  begin
    Par_Name[I] := StringGrid_ParNam.Cells[1, I];
    //   2 : NDIM  NPAR.
    TEMPLATE_();
    Panel5_ParName.Visible := False;
  end;

  tbb_Equa_Save.Enabled := True;    tbb_Equa_Del.Enabled  := True;
end;

//------------------------------------------------------------------- tbb_Equa_Read
procedure TForm2.tbb_Equa_ReadClick(Sender: TObject);
var
  tf : TextFile;    FName : String;
begin
  if cb_Equa.Text = '' then
  begin
    ShowMessage('Set a  Model Name,  press "ENTER" and try once again');    Exit;
  end;

  with OpenDialog1 do
  begin
    InitialDir := CurDir;    Filter := 'Equations (*.dpr)|*.dpr';    FName := 'Special.dpr';
    if Execute then    begin
      if Not FileExists(FName) then Exit;
      Memo_Equa.Lines.LoadFromFile(FName);    end;

    InitialDir := CurDir;    Filter := 'Dimens (*.ish)|*.ish';    FName := 'Dimens.ish';
    if Execute then
      Read_Dimens(FName);
  end;

  tbb_Equa_Save.Enabled := True;    tbb_Equa_Del.Enabled  := True;
end;

//------------------------------------------------------------------- Equa_Clear
procedure TForm2.tb_Equa_ClearClick(Sender: TObject);
begin
    Memo_Equa.Clear;
end;

//------------------------------------------------------------------- Allclear
procedure TForm2.Allclear1Click(Sender: TObject);
var
  I : Integer;
begin
  Memo_Equa.Clear;    cb_Equa.Text := '';
  //ed_NDIM.Clear;    ed_NPAR.Clear;    ed_NMAX.Clear;    ed_NBIF.Clear;    -  !
  with StatusBar2 do
    for I := 0 to 5 do
      Panels[I].Text := '';
end;

//------------------------------------------------------------------- tbb_Equa_Save
procedure TForm2.tbb_Equa_SaveClick(Sender: TObject);
begin
  //ShowMessage('Equa_Save');
  //0_1)   'Special.dpr'   :
  Memo_Equa.Lines.SaveToFile(CurDir + '\Special.dpr');
  ShowMessage('0_1) File  "Special.dpr"  is saved in directory of the project');

  //0_2)      :
  Par_Nam_Save();
ShowMessage('Par_Nam_Save');
  ShowMessage('0_2) Parameters names are preserved in array');
  tbb_Equa_Cmpl.Enabled := True;
end;

//------------------------------------------------------------------ ddb_Save_Dim
procedure TForm2.ddb_Save_DimClick(Sender: TObject);
Var
  tfDim : TextFile;    FName : String;
begin
  //ShowMessage('ddb_Save_Dim');
  with SaveDialog1 do
  begin
    InitialDir := ModelDir;
    Filter     := 'Dimens*.ish|Dimens*.ish';    DefaultExt := '.ish';    FileName   := 'Dimens.ish';
    if Execute then
    begin
      FName := FileName;
      AssignFile(tfDim, FName);    Rewrite(tfDim);
      writeln(tfDim, ed_NDIM.Text);
      writeln(tfDim, ed_NPAR.Text);
      writeln(tfDim, ed_NMAX.Text);
      writeln(tfDim, ed_NBIF.Text);
      CloseFile(tfDim);
    end;
  end;
end;

//------------------------------------------------------------------- tbb_Equa_Cmpl
procedure TForm2.tbb_Equa_CmplClick(Sender: TObject);
// (  )       : "   Special".  ???
var
  tf : TextFile;
begin
  //1)   'Special.dpr'   'BAT_DCU':
  if not WindowsCopyFile(CurDir + '\Special.dpr', CurDir + '\BAT_DCU') then
  begin
    ShowMessage('Copy Failed');    Exit;
  end
  else
    ShowMessage('1) File  "Special.dpr"  is copied to the subdirectory  "\BAT_DCU"');

  //2)    'BAT_DCU':
  SetCurrentDir(CurDir + '\BAT_DCU');
  ShowMessage('2) CurDir =  ' + CurDir + '\BAT_DCU');

  //3)   'Special.dpr' ( -):
  WinExec('compilSpec.bat', SW_RESTORE);

  ShowMessage('3) Compiling is finished');    //  'Syntax.txt'  
  Form_Synt.Memo_Synt.Lines.LoadFromFile(CurDir + '\BAT_DCU' + '\Syntax.txt');
  Form_Synt.ShowModal;

  if MessageDlg('Continue?', mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;        // --- 'Continue?' ---

  //4) -   ! -       :
    ModelDir  := CurDir + '\' + ModelName;
    ShowMessage('4_0) ModelDir = ' + ModelDir);
    If Not DirectoryExists(ModelDir) Then
    begin
      ShowMessage('4_1) We create directory  "' + ModelDir + '"');    CreateDir(ModelDir);

      //5)    (  )   :
      AddNewName();    ShowMessage('5) File  "ModelsList.txt"  is complemented');

      //6)  'ComboBox':
      Refresh_();      ShowMessage('6) List  "ComboBox"  is updated');
    end
    else
    begin
      ShowMessage('4_2) Directory  "' + ModelDir + '"  already exists');
      //- ,  5), 6)   -
    end;

  //7)    . 'ModelDir': //7_1) 'Special.dpr':
  if not WindowsCopyFile(CurDir + '\BAT_DCU' + '\Special.dpr', ModelDir) then
  begin
    ShowMessage('Copy Failed');    Exit;
  end
  else
    ShowMessage('7_1) File  "Special.dpr"  is copied to ModelDir');
                                         //7_2) 'Special.dll':
  if not WindowsCopyFile(CurDir + '\BAT_DCU' + '\Special.dll', ModelDir) then
  begin
    ShowMessage('Copy Failed');    Exit;
  end
  else
    ShowMessage('7_2) File  "Special.dll"  is copied to ModelDir');

  //8)   "Special.dpr"  "Special.dll"  CurDir + '\BAT_DCU':
  DeleteFile(CurDir + '\BAT_DCU' + '\Special.dpr');
  DeleteFile(CurDir + '\BAT_DCU' + '\Special.dll');
  ShowMessage('8) Files  "Special.dll"  and  "Special.dpr"  are removed from directory "\BAT_DCU"');

  //9)   .        NDIM  NPAR:
  AssignFile(tf, ModelDir + '\Dimens.ish');    Rewrite(tf);
  writeln(tf, ed_NDIM.Text);
  writeln(tf, ed_NPAR.Text);
  writeln(tf, ed_NMAX.Text);
  writeln(tf, ed_NBIF.Text);
  CloseFile(tf);
  ShowMessage('9) File  "Dimens.ish"  is copied to ModelDir');
end;




procedure TForm2.tbb_Equa_DelClick(Sender: TObject);
begin
  //ShowMessage('Equa_Del');
  Delete_();
end;

procedure TForm2.tbb_Equa_HelpClick(Sender: TObject);
begin
  winhelp(Form1.Handle,'BPRQ_Help.hlp', HELP_CONTEXT, 20);
end;

procedure TForm2.tbb_Equa_ExitClick(Sender: TObject);
begin
  Close;
end;

end.
