unit UGlobal;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, ToolWin, Menus, Math;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;
  TRenam = procedure(SPar: TD);
  TBond  = procedure(NDIM, N2, N5: Integer;   V: TV;   var G: TV);
  TListB = procedure(LN_: Integer;   Z: TD;   var GG: Double);
  TJacob = procedure(NDIM: Integer;   DD, QMOD: Double;   Q: TD;   var O, R: TD;   var U: TV);
  TListJ = procedure(LN_: Integer;   DD, QMOD: Double;   Z: TD;   var FF: Double);
  TBifC  = procedure(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;   var BFX, BF1, BF2: TD);
  TINAPP = procedure(N5, NDIM, INAP: Integer;   var D : TD;   var V: TV);
  TADFUN = procedure(N5: Integer;   QMOD: Double;   W1: TV;   var W1D: TV);
  
var
  fTABL_Sol, fTABL_Qsl, fTABL_Bif, fTABL_Mul , fTABL_Ina: TextFile;
  NameDir, TaskName: String;
  ISTEP, NBIF: integer;                                // BIFC
  BFX, BF1, BF2,   Spar: TD;
  NIC,   NJC,   NKC: TArr3I;
  N5: integer;                                   // BOND      N2,
  G, V: TV;
  GG: double;                                    // LISTB
  Z: TD;
  H, HDIF, EXD, HMIN: double;                    // BONDN
  IIND, JIND, JAC, NCOM, NMAX: integer;          // DELTA     N,
  D_, DMAX: double;
  D: TD;
  L1, N4, N3: integer;                           // GAUSS
  W: TV;
  N1: integer;                                   // JACOB
  QMOD: double;
  U: TV;
  R, Q, O: TD;
  FF: double;                                    // LISTJ
  IREG: integer;                                 // JACOBN
                                                 // SPLINE    //N6: integer;
  Q8, Q7, P8, P7, T_: double;
  Y, P, F,   W1D: TV;

  HandleLib: THandle;
  Renam : TRenam ;
  Bond  : TBond;
  ListB : TListB;
  Jacob : TJacob;
  ListJ : TListJ;
  BifC  : TBifC;
  INAPP : TINAPP;
  ADFUN : TADFUN;

  procedure BondN;     // standard
  procedure Delta;     // standard
  procedure Gauss;     // standard
  procedure JacobN;    // standard
  procedure Spline;    // standard

implementation

uses
  UProced, UMain;

//=================================================================== BondN()
procedure BondN();
label
  L61, L62;
var
  J, LN_, M: Integer;
  Y_, P1, P2, E9: Double;
begin
  FOR LN_ := 1 TO NDIM do
  begin
    For J := 1 TO NDIM do
    begin
      Q[J] := V[1, J];    Q[J + NDIM] := V[N5, J];
      Z[J] := Q[J];       Z[J + NDIM] := Q[J + NDIM];
    end;    // J
    Q[2 * NDIM + 1] := QMOD;    Z[2 * NDIM + 1] := QMOD;    LISTB(LN_, Z, GG);

    G[LN_, 2 * NDIM + 2] := GG;
    For M := 1 TO 2 * NDIM + 1 do
    begin
      H := HDIF;
      For J := 1 TO 2 * NDIM + 1 do
        Z[J] := Q[J];
      Z[M] := Q[M] - H;    LISTB(LN_, Z, GG);

      Z[M] := Q[M] + H;    Y_ := GG;    LISTB(LN_, Z, GG);

      P1 := 0.5 * (GG - Y_) / H;
L61:  Z[M] := Q[M] - 0.5 * H;    LISTB(LN_, Z, GG);

      Z[M] := Q[M] + 0.5 * H;    Y_ := GG;    LISTB(LN_, Z, GG);

      P2 := (GG - Y_) / H;    E9 := ABS(P2 - P1);
      IF E9 < EXD THEN Goto L62;
      P1 := P2;    H := 0.5 * H;
      IF H > HMIN THEN Goto L61;
      ShowMessage('BONDN, H<HMIN, STOP');
      Exit;
L62:  G[LN_, M] := P2 + (P2 - P1) / 3;
    end;    // M
  end;    // LN_
end;

//=================================================================== Delta()
procedure Delta();
label
  L401, L402, L403, L405, L406, L407, L408, L409, L410, L411, L412;
var
  I, I1, J, K, K1: Integer;
  A1, A2, C0, D0, D9, FFF, R_, TT, V_, Y_: Double;
begin
  //ShowMessage('Delta,   JIND = ' + IntToStr(JIND));
  IF JIND > 0 THEN D9 := D[IIND];
  For I1 := 1 TO N5 do
  begin
    D_ := D[I1];
    For K := 1 TO NDIM do
      Q[K] := V[I1, K];                                                  //ShowMessage('1__Jacob');
    IF JAC = 0 THEN JACOB(NDIM, D_, QMOD, Q, O, R, U) ELSE JACOBN();     //ShowMessage('1__Jacob');
    For K := 1 TO NDIM do
    begin
      P[I1, K] := O[K];
      C0 := U[K, NDIM + 1];
      For J := 1 TO NDIM do
        C0 := C0 + U[K, J] * O[J];
      P[I1 + N5, K] := C0;
    end;    // K
  end;    // I1
  F[1, 1] := 0;
  For I1 := 1 TO NDEL do
  begin
    H := D[I1 + 1] - D[I1];
    FFF := 0.5 * H * (P[I1 + N5, NCOM] + P[I1 + 1 + N5, NCOM]);
    FFF := Power(12 * H * ABS(P[I1, NCOM] - P[I1 + 1, NCOM] + FFF), 0.25);
    F[I1 + 1, 1] := F[I1, 1] + FFF;
  end;    // I1
  IF (F[N5, 1] < 1E-10) THEN exit;
  For I1 := 2 TO N5 do
    F[I1, 1] := F[I1, 1] / F[N5, 1];
  For I1 := 1 TO NDEL - 1 do
  begin
    R_ := I1 / NDEL;    K := 1;
L401:
    IF (R_>= F[K, 1]) AND (R_<= F[K + 1, 1]) THEN Goto L402;
    K := K + 1;    GOTO L401;
L402:
    H := D[K + 1] - D[K];
    IF ABS(F[K + 1, 1] - F[K, 1]) < 0.0000001 THEN T_ := 0.5
    ELSE    T_ := (R_ - F[K, 1]) / (F[K + 1, 1] - F[K, 1]);
    D[NDEL + 2 + I1] := D[K] + H * T_;
    For J := 1 TO NDIM do
    begin
      TT := T_ * (1 - T_);    A1 := H * P[K, J] - V[K + 1, J] + V[K, J];
      A2 := V[K + 1, J] - V[K, J] - H * P[K + 1, J];
      Y_ := (1 - T_) * V[K, J] + T_ * V[K + 1, J];
      Y[I1 + 1, J] := Y_ + TT * ((1 - T_) * A1 + T_ * A2);
    end;    // J
  end;    // I1

  For I1 := 1 TO NDEL - 1 do
  begin
    D_:= D[NDEL + 2 + I1];    D[I1 + 1] := D_;
    For K := 1 TO NDIM do
    begin
      Q[K] := Y[I1 + 1, K];    V[I1 + 1, K] := Q[K];
    end;    // K
  end;    // I1
  I := 1;
L405:
  D0 := D[I + 1] - D[I];
  IF D0 < DMAX THEN Goto L406;
  For K := 1 TO NDIM do
  begin
    Y[I, K] := D0 * P[I, K] - V[I + 1, K] + V[I, K];
    Y[NDEL + 2 + I, K] := V[I + 1, K] - V[I, K] - D0 * P[I + 1, K];
  end;    // K
  K1 := Trunc(D0 / DMAX);    //ShowMessage('K1 = ' + IntToStr(K1));
  H := D0 / (K1 + 1);
  IF K1 + NDEL > NMAX THEN Goto L407;
  For K := NDEL + 1 downto I + 1 do
  begin
    D[K + K1] := D[K];
    For J := 1 TO NDIM do
      V[K + K1, J] := V[K, J];
    For J := 1 TO NDIM do
      P[K + K1, J] := P[K, J];
  end;    // K
  For K := 1 TO K1 do
  begin
    D[I + K] := D[I] + H * K;    T_ := K / (K1 + 1);
    For J := 1 TO NDIM do
    begin
      TT := T_ * (1 - T_);
      V_ := TT * ((1 - T_) * Y[I, J] + T_ * Y[NDEL + 2 + I, J]);
      V[I + K, J] := (1 - T_) * V[I, J] + T_ * V[I + 1 + K1, J] + V_;
    end;    // J
  end;    // K
  NDEL := NDEL + K1;    I := I + K1;
L406:
  I := I + 1;
  IF I > NDEL THEN Goto L407 ELSE GOTO L405;
L407:
  IF IIND = 1 THEN  Goto L412;
  IF JIND > 0 THEN  Goto L408;
  IIND := NDEL + 2;    GOTO L412;
L408:
  I := 1;
L409:
  IF D9 >= D[I] THEN Goto L410;
  I := I + 1;    GOTO L409;
L410:
  IF D9 <= D[I + 1] THEN Goto L411;
  I := I + 1;    GOTO L409;
L411:
  IF D9 > 0.5 * (D[I + 1] + D[I]) THEN IIND := I + 1
  ELSE IIND := I;
L412:
  N5 := NDEL + 1;
  For I1 := 1 TO N5 do
    For J := 1 TO NDIM do
    begin
      IF V[I1, J] < HL[J] THEN V[I1, J] := HL[J];
      IF V[I1, J] > HR[J] THEN V[I1, J] := HR[J];
    end;    // J
end;

//=================================================================== Gauss()
procedure Gauss();
var
  J, K, K0, K1, M: Integer;
  C0, R_: Double;
begin
  For M := 1 TO L1 do
  begin
    C0 := 0;
    For K := M TO N4 do
    begin
      IF ABS(W[K, M]) >= ABS(C0) THEN
      begin
        C0 := W[K, M];    K0 := K;
      end;
    end;    // K
    For J := M TO N3 do
    begin
      Q[J] := W[K0, J];    W[K0, J] := W[M, J];    W[M, J] := Q[J];
    end;    // J
    K1 := M + 1;
      //ShowMessage('N4 = ' + IntToStr(N4));
    For K := K1 TO N4 do
    begin
      //If C0 <> 1 Then ShowMessage('C0 = ' + FloatToStr(C0));
      R_ := W[K, M] / C0;
      For J := K1 TO N3 do
        W[K, J] := W[K, J] - R_ * Q[J];
    end;    // K
  end;    // M
end;

//=================================================================== JacobN()
procedure JacobN();
label
  L71, L72;
var
  J, LN_, M: Integer;
  Y_, P1, P2, E9: Double;
begin
  IREG := 0;
  FOR LN_ := 1 TO NDIM do
  begin
    For J := 1 TO NDIM do
      Z[J] := Q[J];
    Q[N1] := QMOD;    Z[N1] := QMOD;    LISTJ(LN_, D_, QMOD, Z, FF);

    O[LN_] := FF;
    For M := 1 TO N1 do
    begin
      H := HDIF;
      For J := 1 TO N1 do
        Z[J] := Q[J];
      Z[M] := Q[M] - H;    LISTJ(LN_, D_, QMOD, Z, FF);

      Z[M] := Q[M] + H;    Y_ := FF;    LISTJ(LN_, D_, QMOD, Z, FF);

      P1 := 0.5 * (FF - Y_) / H;
L71:  Z[M] := Q[M] - 0.5 * H;    LISTJ(LN_, D_, QMOD, Z, FF);

      Z[M] := Q[M] + 0.5 * H;    Y_ := FF;    LISTJ(LN_, D_, QMOD, Z, FF);

      P2 := (FF - Y_) / H;    E9 := ABS(P2 - P1);
      IF E9 < EXD THEN Goto L72;
      P1 := P2;    H := 0.5 * H;
      IF H > HMIN THEN Goto L71;
      ShowMessage('jacobn, h<hmin, end');
      Exit;
L72:  U[LN_, M] := P2 + (P2 - P1) / 3;
    end;    // M
    R[LN_] := U[LN_, N1];    U[LN_, N1] := 0;
  end;    // LN_
end;

//=================================================================== Spline()
procedure Spline();
var
  I, K: Integer;
  R_, TT, TT1, TT2, TTT: Double;
begin
  For I := 1 TO N5 do
    For K := 1 TO NDIM do
    begin
      R_ := Y[I + N5, K] * (1 + 2 * T_) * (1 - T_) * (1 - T_);
      R_ := R_ + V[I, K] * (3 - 2 * T_) * T_ * T_;
      TT := H * T_ * (1 - T_);
      Y[I, K] := R_ + TT * ((1 - T_) * P[I + N5, K] + T_ * F[I + 2 * N5, K]);
      R_ := 6 * T_ * (1 - T_) * (V[I, K] - Y[I + N5, K]) / H;
      TT1 := (1 - T_) * (1 - 3 * T_);
      TT2 := T_ * (2 - 3 * T_);
      P[I, K] := R_ + TT1 * P[I + N5, K] + TT2 * F[I + 2 * N5, K];
    end;    // K
    R_ := Q8 * (1 + 2 * T_) * (1 - T_) * (1 - T_) + QMOD * (3 - 2 * T_) * T_ * T_;
    q7 := R_ + H * T_ * (1 - T_) * ((1 - T_) * P8 + T_ * Q[2 * NDIM + 2]);
    R_ := 6 * T_ * (1 - T_) * (QMOD - Q8) / H;
    TTT := T_ * (2 - 3 * T_);
    P7 := R_ + (1 - T_) * (1 - 3 * T_) * P8 + TTT * Q[2 * NDIM + 2];
end;

end.


