unit UMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ImgList, ExtCtrls, ToolWin, StdCtrls, Math, Grids, Menus,
  AppEvnts, jpeg;

type
  TForm1 = class(TForm)
    PageControl_W: TPageControl;
    TabSheet4: TTabSheet;
    ToolBar2: TToolBar;
    tbb_Equa_Help: TToolButton;
    tbb_Equa_Exit: TToolButton;
    TabSheet_Calc: TTabSheet;
    ToolBar6: TToolBar;
    tbb_Calc_Run: TToolButton;
    tbb_Calc_Help: TToolButton;
    tbb_Calc_Exit: TToolButton;
    Panel_VL: TPanel;
    Label2: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Label16: TLabel;
    Label18: TLabel;
    Panel_NL: TPanel;
    Label12: TLabel;
    Label13: TLabel;
    Edit1: TEdit;
    NuCo_L1: TEdit;
    NuCo_L2: TEdit;
    NuCo_L3: TEdit;
    NuCo_L4: TEdit;
    NuCo_L5: TEdit;
    eXMin: TEdit;
    eMin_L1: TEdit;
    eMin_L2: TEdit;
    eMin_L3: TEdit;
    eMin_L4: TEdit;
    eMin_L5: TEdit;
    eXMax: TEdit;
    eMax_L1: TEdit;
    eMax_L2: TEdit;
    eMax_L3: TEdit;
    eMax_L4: TEdit;
    eMax_L5: TEdit;
    Panel_NP: TPanel;
    Label14: TLabel;
    Label15: TLabel;
    Edit7: TEdit;
    NuCo_P1: TEdit;
    NuCo_P2: TEdit;
    eQMin: TEdit;
    eMin_P1: TEdit;
    eMin_P2: TEdit;
    eQMax: TEdit;
    eMax_P1: TEdit;
    eMax_P2: TEdit;
    Panel_VP: TPanel;
    Label3: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    Label11: TLabel;
    Label17: TLabel;
    Label19: TLabel;
    TabSheet9: TTabSheet;
    ToolBar7: TToolBar;
    tbb_Tabl_Help: TToolButton;
    tbb_Tabl_Exit: TToolButton;
    Panel_Tabl: TPanel;
    Memo_Tabl: TMemo;
    ImageList1: TImageList;
    StatusBar1: TStatusBar;
    lQmod: TLabel;
    lStepN: TLabel;
    Qmod: TLabel;
    Label22: TLabel;
    lIndex: TLabel;
    lInacc: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton13: TToolButton;
    ImageList2: TImageList;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    tbb_Tabl_Read: TToolButton;
    tbb_Tabl_Clear: TToolButton;
    ToolButton25: TToolButton;
    ToolButton27: TToolButton;
    tbb_Calc_Clear: TToolButton;
    ToolButton21: TToolButton;
    TabSheet1: TTabSheet;
    ToolBar8: TToolBar;
    tbb_Meth_Read: TToolButton;
    ToolButton5: TToolButton;
    tbb_Meth_Save: TToolButton;
    ToolButton9: TToolButton;
    tbb_Meth_Help: TToolButton;
    ToolButton15: TToolButton;
    tbb_Meth_Exit: TToolButton;
    Panel2: TPanel;
    StringGrid_Meth: TStringGrid;
    Label20: TLabel;
    PaintBox1: TPaintBox;
    PaintBox2: TPaintBox;
    ToolButton3: TToolButton;
    pum_Cr_Re: TPopupMenu;
    pum_Clear1: TMenuItem;
    ApplicationEvents1: TApplicationEvents;
    pum_Cr_He1: TPopupMenu;
    Delphi1: TMenuItem;
    pum_Temp1: TMenuItem;
    PopupMenu1: TPopupMenu;
    pum_Clear2: TMenuItem;
    Model: TTabSheet;
    ToolBar3: TToolBar;
    tbb_Modl_Read: TToolButton;
    ToolButton14: TToolButton;
    tbb_Modl_Save: TToolButton;
    ToolButton17: TToolButton;
    tbb_Modl_Help: TToolButton;
    ToolButton24: TToolButton;
    tbb_Modl_Exit: TToolButton;
    Panel5: TPanel;
    Label40: TLabel;
    StringGrid_Modl: TStringGrid;
    Problem1: TMenuItem;
    Panel_ReaM: TPanel;
    Memo_Equa: TMemo;
    Label1: TLabel;
    eQSolv: TEdit;
    Label21: TLabel;
    StringGrid_Prob: TStringGrid;
    tbb_Calc_Save: TToolButton;
    ToolButton1: TToolButton;
    tbb_Calc_Read: TToolButton;
    ToolButton6: TToolButton;
    Mod_Prob_Read: TPopupMenu;
    Mod_Prob_Save: TPopupMenu;
    Problem_Read: TMenuItem;
    Problem_Save: TMenuItem;
    procedure Problem_SaveClick(Sender: TObject);
    procedure Problem_ReadClick(Sender: TObject);
    procedure tbb_Calc_ReadClick(Sender: TObject);
    procedure tbb_Calc_SaveClick(Sender: TObject);
    procedure tbb_Modl_ExitClick(Sender: TObject);
    procedure tbb_Modl_HelpClick(Sender: TObject);
    procedure tbb_Modl_SaveClick(Sender: TObject);
    procedure tbb_Modl_ReadClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Delphi1Click(Sender: TObject);
    procedure ApplicationEvents1Hint(Sender: TObject);
    procedure PaintBox2Paint(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure tbb_Meth_SaveClick(Sender: TObject);
    procedure tbb_Meth_ReadClick(Sender: TObject);
    procedure tbb_Calc_ClearClick(Sender: TObject);
    procedure tbb_Tabl_ClearClick(Sender: TObject);
    procedure tbb_Tabl_ReadClick(Sender: TObject);
    procedure tbb_Tabl_ExitClick(Sender: TObject);
    procedure tbb_Tabl_HelpClick(Sender: TObject);
    procedure tbb_Calc_HelpClick(Sender: TObject);
    procedure tbb_Calc_RunClick(Sender: TObject);
    procedure tbb_Calc_ExitClick(Sender: TObject);
    procedure tbb_Meth_ExitClick(Sender: TObject);
    procedure tbb_Meth_HelpClick(Sender: TObject);
    procedure tbb_Equa_ExitClick(Sender: TObject);
    procedure tbb_Equa_HelpClick(Sender: TObject);
    procedure tbb_Main_ExitClick(Sender: TObject);
    procedure tbb_Main_HelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Problem1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TD     = array of Double;
  TV     = array of array of Double;
  TCol   = array [1..6] of TColor;
  TCol1  = array [1..4] of TColor;
  TArr3D = array [0..3] of Double;

const
  Col:  TCol  = (clBlue, clLime, clAqua, clRed, clFuchsia, clYellow);
  Col1: TCol1 = ($005313d3, $00d31393, $0044CCCC, $00F0FFFF);

var
  Form1: TForm1;
  CurDir, ModelName, ModelDir : String;
  A, X, T, E_, B: TV;
  YS, HV, HY, HL, HR: TD;
  Wid_Lev, Hei_Lev, Ser_Hor, Ser_Ver: Integer;
  NDEL, IPAR, LIM0, LIM, NSTEP, NEND, I0, I4, I6, I8, J8, K9, L5, ISOLV, IBIF,
  L0,   MARK_, BON, INAP, ADF: integer;
  QSTEP, DIREC, EMIN, ACCEL, EMAX, EXACT, EX0, QSOLV, HMOD, QMODS, QMIN, QMAX, C9: double;
  XMIN, XMAX: double;
  MT1, MT2, MT3, MT4, MT5: array of TPoint;
  ITABL,    MTIx: integer;
  ICL, ICR,   JCL, JCR,   KCL, KCR: TArr3D;
  CIm, CJm, CKm: TArr3D;                      //'3 - Max  ,   
  Par_Name : Array of String;
  BitMapL, BitMapP: TBitMap;
  NPAR_div, NPAR_mod : Integer;

implementation

uses
  UGlobal, UProced, Unit4, Unit3, Start;

  {$R *.dfm}


//------------------------------------------------------------------------------------------------------------ FormCreate
//------------------------------------------------------------------------------------------------------------ FormCreate
//------------------------------------------------------------------------------------------------------------ FormCreate
procedure TForm1.FormCreate(Sender: TObject);
begin
 //cb_Equa.ItemIndex := 0;       //       

  Refresh_();

  PageControl_W.TabIndex := 3;

  Wid_Lev := PaintBox1.Width;     Ser_Hor := round(Wid_Lev / 2);
  Hei_Lev := PaintBox1.Height;    Ser_Ver := round(Hei_Lev / 2);

  BitMapL := TBitMap.Create;    BitMapL.Width := 423;    BitMapL.Height := 461;
  BitMapP := TBitMap.Create;    BitMapP.Width := 423;    BitMapP.Height := 461;

        //Form4.Left    := Form1.Left + 417;
        //Form4.Top     := Form1.Top  + 548;

  with StatusBar1 do    begin
    Panels[6].Text := DateToStr(Date);    Panels[7].Text := TimeToStr(Time);    end;
end;


//------------------------------------------------------------------- FormDestroy
procedure TForm1.FormDestroy(Sender: TObject);
begin
  BitMapL.Free;      BitMapP.Free;
  FreeLibrary(HandleLib);
end;


//------------------------------------------------------------------- ApplicationEvents1Hint
procedure TForm1.ApplicationEvents1Hint(Sender: TObject);
begin    StatusBar1.Panels[1].Text := Application.Hint;    end;


//--------------------------------------------------------------------------------------- Main
//------------------------------------------------------------------- Main_Help
procedure TForm1.tbb_Main_HelpClick(Sender: TObject);
begin    winhelp(Form1.Handle,'BPRQ_Help.hlp', HELP_CONTEXT, 4);    end;                   //_Help

//------------------------------------------------------------------- Main_Exit
procedure TForm1.tbb_Main_ExitClick(Sender: TObject);
begin
  Close;    Form2.Show;
end;


//------------------------------------------------------------------- Equa_Help
procedure TForm1.tbb_Equa_HelpClick(Sender: TObject);
begin
  winhelp(Form1.Handle,'BPRQ_Help.hlp', HELP_CONTEXT, 6);
end;

//------------------------------------------------------------------- Equa_Delphi
procedure TForm1.Delphi1Click(Sender: TObject);
begin
  winhelp(Form1.Handle,'Delphi.hlp', HELP_CONTEXT, 1);
end;

//------------------------------------------------------------------- Equa_Exit
procedure TForm1.tbb_Equa_ExitClick(Sender: TObject);
begin
  Close;    Form2.Show;
end;


//--------------------------------------------------------------------------------------- Meth
//------------------------------------------------------------------- Meth_Read
procedure TForm1.tbb_Meth_ReadClick(Sender: TObject);
var
  FName : String;
begin
  with OpenDialog1 do    begin    InitialDir := ModelDir;
    Filter     := 'Meth_Param*.ish|Meth_Param*.ish|All  Files (*.*)|*.*';
    FileName   := 'Meth_Param.ish';
    if Execute then    begin
      FName := FileName;                     Meth_Param_Read(FName);
      Delete(FName, 1, Length(ModelDir));    StatusBar1.Panels[2].Text := FName;    end;    end;
end;

//------------------------------------------------------------------- Meth_Save
procedure TForm1.tbb_Meth_SaveClick(Sender: TObject);
Var
  tfMeth : TextFile;    FName : String;
begin
  with SaveDialog1 do
  begin
    InitialDir := ModelDir;
    Filter     := 'Meth_Param*.ish|Meth_Param*.ish';    DefaultExt := '.ish';    FileName   := 'Meth_Param.ish';
    if Execute then
    begin
      FName := FileName;
      AssignFile(tfMeth, FName);    Rewrite(tfMeth);
      With Form1.StringGrid_Meth do
      begin
        writeln(tfMeth, Cells[1,  1]);
        writeln(tfMeth, Cells[1,  2]);
        writeln(tfMeth, Cells[1,  3]);
        writeln(tfMeth, Cells[1,  4]);
        writeln(tfMeth, Cells[1,  5]);
        writeln(tfMeth, Cells[1,  6]);
        writeln(tfMeth, ''          );
        writeln(tfMeth, ''          );
        writeln(tfMeth, Cells[1,  9]);
        writeln(tfMeth, ''          );
        writeln(tfMeth, ''          );
        writeln(tfMeth, ''          );
        writeln(tfMeth, Cells[1, 13]);
        writeln(tfMeth, Cells[1, 14]);
        writeln(tfMeth, Cells[1, 15]);
        writeln(tfMeth, Cells[1, 16]);
        writeln(tfMeth, Cells[1, 17]);
        writeln(tfMeth, Cells[1, 18]);
        writeln(tfMeth, Cells[1, 19]);
        writeln(tfMeth, Cells[1, 20]);
        writeln(tfMeth, Cells[1, 21]);
        writeln(tfMeth, Cells[1, 22]);
        writeln(tfMeth, Cells[1, 23]);
        writeln(tfMeth, Cells[1, 24]);
        writeln(tfMeth, Cells[1, 25]);
        writeln(tfMeth, Cells[1, 26]);
        writeln(tfMeth, Cells[1, 27]);
        writeln(tfMeth, Cells[1, 28]);
        writeln(tfMeth, Cells[1, 29]);
        writeln(tfMeth, Cells[1, 30]);
        writeln(tfMeth, ''          );
        writeln(tfMeth, Cells[1, 32]);
      end;
      CloseFile(tfMeth);
    end;
  end;
end;

//------------------------------------------------------------------- Meth_Help
procedure TForm1.tbb_Meth_HelpClick(Sender: TObject);
begin
  winhelp(Form1.Handle,'BPRQ_Help.hlp',HELP_CONTEXT,7);
end;

//------------------------------------------------------------------- Meth_Exit
procedure TForm1.tbb_Meth_ExitClick(Sender: TObject);
begin
  Close;    Form2.Show;
end;


//--------------------------------------------------------------------------------------- Modl_Prob
//------------------------------------------------------------------- Modl_Read
procedure TForm1.tbb_Modl_ReadClick(Sender: TObject);
var
  FName : String;
begin
  with OpenDialog1 do    begin    InitialDir := ModelDir;
    Filter     := 'Modl_Param*.ish|Modl_Param*.ish|All  Files (*.*)|*.*';
    FileName   := 'Modl_Param.ish';
    if Execute then    begin
      FName := FileName;                     Modl_Param_Read(FName);
      Delete(FName, 1, Length(ModelDir));    StatusBar1.Panels[3].Text := FName;    end;    end;
end;

//------------------------------------------------------------------- Prob_Read
procedure TForm1.Problem_ReadClick(Sender: TObject);
var
  FName : String;
begin
  with OpenDialog1 do    begin    InitialDir := ModelDir;
    Filter     := 'Prob_Param*.ish|Prob_Param*.ish|All  Files (*.*)|*.*';
    FileName   := 'Prob_Param.ish';
    if Execute then    begin
      FName := FileName;                     Prob_Param_Read(FName);
      Delete(FName, 1, Length(ModelDir));    StatusBar1.Panels[4].Text := FName;    end;    end;
end;

//------------------------------------------------------------------- Modl_Save
procedure TForm1.tbb_Modl_SaveClick(Sender: TObject);
var
  tf : TextFile;    FName : String;    I : Integer;
begin
  with SaveDialog1 do
  begin
    InitialDir := ModelDir;
    Filter     := 'Modl_Param*.ish|Modl_Param*.ish';    DefaultExt := '.ish';    FileName   := 'Modl_Param.ish';
    if Execute then
    begin
      FName := FileName;
      AssignFile(tf, FName);    Rewrite(tf);
      With StringGrid_Modl do
      begin
        for I := 1 to NPAR do
          writeln(tf, Cells[1,    I]);
      end;
      CloseFile(tf);
    end;
  end;
end;

//------------------------------------------------------------------- Prob_Save
procedure TForm1.Problem_SaveClick(Sender: TObject);
var
  tf : TextFile;    FName : String;    I : Integer;
begin
  with SaveDialog1 do
  begin
    InitialDir := ModelDir;
    Filter     := 'Prob_Param*.ish|Prob_Param*.ish';    DefaultExt := '.ish';    FileName   := 'Prob_Param.ish';
    if Execute then
    begin
      FName := FileName;
      AssignFile(tf, FName);    Rewrite(tf);
      With StringGrid_Prob do
      begin
        for I := 1 to NDIM do    writeln(tf, Cells[1, 1 + I]);
                                 writeln(tf, Cells[1, NDIM + 2]);    writeln(tf, '');
        for I := 1 to NDIM do    writeln(tf, Cells[2, 1 + I]);
                                 writeln(tf, Cells[2, NDIM + 2]);    writeln(tf, '');
        for I := 1 to NDIM do    writeln(tf, Cells[3, 1 + I]);       writeln(tf, '');
        for I := 1 to NDIM do    writeln(tf, Cells[4, 1 + I]);       writeln(tf, '');
        for I := 1 to NDIM do    writeln(tf, Cells[5, 1 + I]);                           end;    CloseFile(tf);
    end;
  end;
end;

//------------------------------------------------------------------- Modl_Help
procedure TForm1.tbb_Modl_HelpClick(Sender: TObject);
begin
  winhelp(Handle,'BPRQ_Help.hlp',HELP_CONTEXT,8);
end;

//------------------------------------------------------------------- Modl_Exit
procedure TForm1.tbb_Modl_ExitClick(Sender: TObject);
begin
  Close;    Form2.Show;
end;


//==================================================================================================== Print()
procedure Print();
var
  I, J, IH : Integer;    Str1, Str2 : String;
begin
  Case MARK_ Of
    1: // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 1
      begin    //ShowMessage('MARK_ = 1');
      end;
    2: // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 2
      begin    //ShowMessage('MARK_ = 2');
                              SetLength (MT1, NDEL+1);
          if NIC[2] <> 0 then SetLength (MT2, NDEL+1);
          if NIC[3] <> 0 then SetLength (MT3, NDEL+1);
          if NJC[1] <> 0 then SetLength (MT4, NDEL+1);
          if NJC[2] <> 0 then SetLength (MT5, NDEL+1);
                                                                          //ShowMessage('JCR[1] = ' + FloatToStr(JCR[1]));
          FOR I := 0 TO NDEL do
          begin
                  MTIx := round(CIm[0] * (D[I+1]         - XMIN));
              MT1[I].x := MTIx;
              MT1[I].y := round(CIm[1] * (V[I+1, NIC[1]] - ICR[1]));
            if NIC[2]  <> 0 then                                          begin
              MT2[I].x := MTIx;
              MT2[I].y := round(CIm[2] * (V[I+1, NIC[2]] - ICR[2]));      end;
            if NIC[3]  <> 0 then                                          begin
              MT3[I].x := MTIx;
              MT3[I].y := round(CIm[3] * (V[I+1, NIC[3]] - ICR[3]));      end;
            if NJC[1]  <> 0 then                                          begin
              MT4[I].x := MTIx;
              MT4[I].y := round(CJm[1] * (W1D[I+1, NJC[1]] - JCR[1]));    //ShowMessage('MT4[I].y = ' + IntToStr(MT4[I].y));
                                                                          end;
            if NJC[2]  <> 0 then                                          begin
              MT5[I].x := MTIx;
              MT5[I].y := round(CJm[2] * (W1D[I+1, NJC[2]] - JCR[2]));    end;
          end;

        with BitMapL.Canvas do
        begin
          Pen.Style := psSolid;    Pen.Color := $00000000;    Pen.Width := 1;    Brush.Color := $00F0FFFF;
          Rectangle(0, 0, Wid_Lev, Hei_Lev);

          Pen.Style := psDot;      Pen.Color := $00AAAAAA;    Pen.Width := 1;
          MoveTo(0, Ser_Ver);      LineTo(Wid_Lev, Ser_Ver);
          MoveTo(Ser_Hor, 0);      LineTo(Ser_Hor, Hei_Lev);

          Pen.Style := psSolid;    Pen.Width := 2;
            Pen.Color := Col[1];   PolyLine(MT1);
          if NIC[2] <> 0 then                        begin
            Pen.Color := Col[2];   PolyLine(MT2);    end;
          if NIC[3] <> 0 then                        begin
            Pen.Color := Col[3];   PolyLine(MT3);    end;
          if NJC[1] <> 0 then                        begin
            Pen.Color := Col[4];   PolyLine(MT4);    end;
          if NJC[2] <> 0 then                        begin
            Pen.Color := Col[5];   PolyLine(MT5);    end;
        end;
        Form1.PaintBox1.Canvas.Draw(0,0,BitMapL);

        writeln(fTABL_Sol, '');                                             // ------------------------- fTABL_Sol
        writeln(fTABL_Sol, '  ISTEP = ' + IntToStr(ISTEP));
        writeln(fTABL_Sol, '  IIND  = ' + IntToStr(IIND));
        writeln(fTABL_Sol, '  JIND  = ' + IntToStr(ISTEP));
        writeln(fTABL_Sol, '');
        writeln(fTABL_Sol, '  QMOD  = ' + FloatToStrF(QMOD, ffexponent, 6, 2));
        writeln(fTABL_Sol, '');

            Str1 := '    D(I)       V(I,1)';
            for I := 2 to NDIM do
              Str1 := Str1 + '       ' + 'V(I,' + IntToStr(I) + ')';
            writeln(fTABL_Sol, Str1);
            Str2 := ' +---------+------------+';
            for I := 2 to NDIM do
              Str2 := Str2 + '------------+';
            writeln(fTABL_Sol, Str2);

        IH := 1;
        for I := 1 to N5 do              //STEP ITABL
        begin
          if I < IH then continue;
          Str1 := '  ' + FloatToStrF(D[IH], ffexponent, 3, 2);
          for J := 1 to NDIM do
            if V[IH, J] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(V[IH, J], ffexponent, 6, 2)
            else                  Str1 := Str1 + '  ' + FloatToStrF(V[IH, J], ffexponent, 5, 2);
          writeln(fTABL_Sol, Str1);
          IH := IH + ITABL;
        end;
        if ITABL * INT(N5 / ITABL) = N5 then
        begin
          I := N5;
            Str1 := '  ' + FloatToStrF(D[I], ffexponent, 3, 2);
            for J := 1 to NDIM do
              if V[I, J] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(V[I, J], ffexponent, 6, 2)
              else                 Str1 := Str1 + '  ' + FloatToStrF(V[I, J], ffexponent, 5, 2);
            writeln(fTABL_Sol, Str1);
         end;
         writeln(fTABL_Sol, '');    writeln(fTABL_Sol, '  NDEL  = ' + IntToStr(NDEL));
      end;

    3: // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 3
      begin    //ShowMessage('MARK_ = 3');
        Form4.Left    := Form1.Left + 417;
        Form4.Top     := Form1.Top  + 548;
        Form4.Button1.Caption := ' Solution # ' + IntToStr(ISOLV);
        Form4.ShowModal;

        writeln(fTABL_Qsl, '');                                             // ------------------------- fTABL_Qsl
        writeln(fTABL_Qsl, '  ISOLV = ' + IntToStr(ISOLV));
        writeln(fTABL_Qsl, '');
        writeln(fTABL_Qsl, '  QMOD  = ' + FloatToStrF(QSOLV, ffexponent, 6, 2));
        writeln(fTABL_Qsl, '');

            Str1 := '    D(I)       Y(I,' + IntToStr(NIC[1]) + ')';
            if NIC[2] <> 0 then Str1 := Str1 + '       Y(I,' + IntToStr(NIC[2]) + ')';
            if NIC[3] <> 0 then Str1 := Str1 + '       Y(I,' + IntToStr(NIC[3]) + ')';
            writeln(fTABL_Qsl, Str1);
            Str2 := ' +---------+------------+';
            if NIC[2] <> 0 then Str2 := Str2 + '------------+';
            if NIC[3] <> 0 then Str2 := Str2 + '------------+';
            writeln(fTABL_Qsl, Str2);

            for I := 1 to N5 do
            begin
              Str1 := '  ' + FloatToStrF(D[I], ffexponent, 6, 2);
              if Y[I, NIC[1]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[1]], ffexponent, 6, 2)
              else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[1]], ffexponent, 5, 2);
              if NIC[2] <> 0 then
                if Y[I, NIC[2]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[2]], ffexponent, 6, 2)
                else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[2]], ffexponent, 5, 2);
              if NIC[3] <> 0 then
                if Y[IH, NIC[3]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[3]], ffexponent, 6, 2)
                else                       Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[3]], ffexponent, 5, 2);
              writeln(fTABL_Qsl, Str1);
            end;

        writeln(fTABL_Qsl, '');
        writeln(fTABL_Qsl, '  NDEL  = ' + IntToStr(NDEL));
      end;
    4: // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 4
      begin    //ShowMessage('MARK_ = 4');
        writeln(fTABL_Bif, '');                                             // ------------------------- fTABL_Bif
        writeln(fTABL_Bif, '  IBIF  = ' + IntToStr(IBIF));
        writeln(fTABL_Bif, '');
        writeln(fTABL_Bif, '  QMOD  = ' + FloatToStrF(QMOD, ffexponent, 6, 2));
        writeln(fTABL_Bif, '');
        Str1 := '    D(I)       Y(I,' + IntToStr(NIC[1]) + ')';
        if NIC[2] <> 0 then Str1 := Str1 + '       Y(I,' + IntToStr(NIC[2]) + ')';
        if NIC[3] <> 0 then Str1 := Str1 + '       Y(I,' + IntToStr(NIC[3]) + ')';
        writeln(fTABL_Bif, Str1);
        Str2 := ' +---------+------------+';
        if NIC[2] <> 0 then Str2 := Str2 + '------------+';
        if NIC[3] <> 0 then Str2 := Str2 + '------------+';
        writeln(fTABL_Bif, Str2);
        for I := 1 to N5 do
        begin
          Str1 := '  ' + FloatToStrF(D[I], ffexponent, 3, 2);
          if Y[I, NIC[1]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[1]], ffexponent, 6, 2)
          else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[1]], ffexponent, 5, 2);
          if NIC[2] <> 0 then
            if Y[I, NIC[2]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[2]], ffexponent, 6, 2)
            else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[2]], ffexponent, 5, 2);
          if NIC[3] <> 0 then
            if Y[I, NIC[3]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[3]], ffexponent, 6, 2)
            else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[3]], ffexponent, 5, 2);
          writeln(fTABL_Bif, Str1);
        end;
        writeln(fTABL_Bif, '');    writeln(fTABL_Bif, '  NDEL  = ' + IntToStr(NDEL));
      end;
  end;
end;    // Print

//============================================================================================= Message_Exit()
procedure Message_Exit();
//     (s.1462, s.1511, s.1553 - ?)
begin
  CloseFile(fTABL_Sol);
  CloseFile(fTABL_Qsl);
  CloseFile(fTABL_Bif);
  CloseFile(fTABL_Mul);
  //ShowMessage('Message_Exit');
end;


//--------------------------------------------------------------------- PageControl_WChange - ?
//procedure TForm1.PageControl_WChange(Sender: TObject);
//begin    //ShowMessage('PageControl_WChange');
  //if PageControl_W.TabIndex = 1 then cb_Equa.SetFocus;
//end;

//--------------------------------------------------------------------- PaintBox1
procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  Form1.PaintBox1.Canvas.Draw(0, 0, BitMapL);
end;

//--------------------------------------------------------------------- PaintBox2
procedure TForm1.PaintBox2Paint(Sender: TObject);
begin
  Form1.PaintBox2.Canvas.Draw(0, 0, BitMapP);
end;


//================================================================================================ Calc_Draw()
procedure Calc_Draw();
label
  L100, L101, L102, L110, L200, L201, L202, L210, L211, L212, L213, L214, L215, L300, L301, L302, L310,          //L150, 
  L311, L312, L313, L314, L320, L321, L322, L323, L324, L325, L326, L327, L328, L331, L332, L333, L334, L335,
  L336, L337, L338, L339, L340, L341, L342, L343, L344, L345, L346, L347, L348, L349,
  M10, M20, M30, M40, M50;
var
  tf1: TextFile;
  I, J, J0, IC_, K, K1, K2, K3, KSOLV, L, L2, L3, L4, L9, M, M7, M8, M9, MK1, MK2, MM2, MM3, IN_, I1: Integer;
  C0, C1, C2, DF, F1, F2, FFF, H0, H1, H2, H3, H5, H6, H7, HT, P_, P0, R_, R0, R1, R2, T1, T2, TT: Double;
  XX1, Y11, Y21, Y31,    XX2, Y12, Y22, Y32,    XX3, Y13, Y23, Y33,    f11, f12, f21, f22,   XXSolv: Integer;
  Str, Str1, Str2, Sib: String;
  fTABL: TextFile;
  dNEND: Integer;
  PI1, PI2, S0, S1, Z1, Z2 : Double;
begin
  //ShowMessage('Calc_Draw_Begin');
  with Form1.StringGrid_Meth do                //-------------------Meth_Input
  begin
      //ShowMessage('Calc_Draw: Meth_Input');
    NDEL  := StrToInt(Cells[  1,  1]);    //ShowMessage('NDEL  = ' + IntToStr(NDEL));
    QMOD  := StrToFloat(Cells[1,  2]);    //ShowMessage('QMOD  = ' + FloatToStr(QMOD));
    QSTEP := StrToFloat(Cells[1,  3]);    //ShowMessage('QSTEP = ' + FloatToStr(QSTEP));
    DIREC := StrToFloat(Cells[1,  4]);    //ShowMessage('DIREC = ' + FloatToStr(DIREC));
    IIND  := StrToInt(Cells[  1,  5]);    //ShowMessage('IIND  = ' + IntToStr(IIND));
    JIND  := StrToInt(Cells[  1,  6]);    //ShowMessage('JIND  = ' + IntToStr(JIND));
    IPAR  := StrToInt(Cells[  1,  9]);    //ShowMessage('IPAR  = ' + IntToStr(IPAR));
    EMIN  := StrToFloat(Cells[1, 13]);    //ShowMessage('EMIN  = ' + FloatToStr(EMIN));
    ACCEL := StrToFloat(Cells[1, 14]);    //ShowMessage('ACCEL = ' + FloatToStr(ACCEL));
    EMAX  := StrToFloat(Cells[1, 15]);    //ShowMessage('EMAX  = ' + FloatToStr(EMAX));
    EXACT := StrToFloat(Cells[1, 16]);    //ShowMessage('EXACT = ' + FloatToStr(EXACT));
    LIM0  := StrToInt(Cells[  1, 17]);    //ShowMessage('LIM0  = ' + IntToStr(LIM0));
    LIM   := StrToInt(Cells[  1, 18]);    //ShowMessage('LIM   = ' + IntToStr(LIM));
    NCOM  := StrToInt(Cells[  1, 19]);    //ShowMessage('NCOM  = ' + IntToStr(NCOM));
    DMAX  := StrToFloat(Cells[1, 20]);    //ShowMessage('DMAX  = ' + FloatToStr(DMAX));
    NSTEP := StrToInt(Cells[  1, 21]);    //ShowMessage('NSTEP = ' + IntToStr(NSTEP));
    EX0   := StrToFloat(Cells[1, 22]);    //ShowMessage('EX0   = ' + FloatToStr(EX0));
    NEND  := StrToInt(Cells[  1, 23]);    //ShowMessage('NEND  = ' + IntToStr(NEND));
    HDIF  := StrToFloat(Cells[1, 24]);    //ShowMessage('HDIF  = ' + FloatToStr(HDIF));
    EXD   := StrToFloat(Cells[1, 25]);    //ShowMessage('EXD   = ' + FloatToStr(EXD));
    HMIN  := StrToFloat(Cells[1, 26]);    //ShowMessage('HMIN  = ' + FloatToStr(HMIN));
    ITABL := StrToInt(Cells[  1, 27]);    //ShowMessage('ITABL = ' + IntToStr(ITABL));
    BON   := StrToInt(Cells[  1, 28]);    //ShowMessage('BON   = ' + IntToStr(BON));
    JAC   := StrToInt(Cells[  1, 29]);    //ShowMessage('JAC   = ' + IntToStr(JAC));
    INAP  := StrToInt(Cells[  1, 30]);    //ShowMessage('INAP  = ' + IntToStr(INAP));
    ADF   := StrToInt(Cells[  1, 32]);    //ShowMessage('ADF   = ' + IntToStr(ADF));
  end;

  if NEND > NBIF then
  begin
    ShowMessage('NEND > NBIF,   Exit');    Message_Exit();    Exit;    end;

  M8 := 0;    //     

  N5    := NDEL + 1;    L5   := NDIM + 1;
  I0    := 0;           I1   := 0;           I4    := 0;    I6 := 0;
  I8    := IIND;        J8   := JIND;        K9    := 1;
  ISOLV := 0;           IBIF := 0;           ISTEP := 0;

  with Form1.StringGrid_Modl do                //-------------------Modl_Input
  begin
      //ShowMessage('Calc_Draw: Modl_Input');
    for I := 1 to NPAR do    Spar[I] := StrToFloat(Cells[1,        I]);
    RENAM(SPar);
  end;

  with Form1.StringGrid_Prob do                //-------------------Prob_Input
  begin
      //ShowMessage('Calc_Draw: Prob_Input');
    for I := 1 to NDIM do      HV[I] := StrToFloat(Cells[1,    1 + I]);
                               HMOD  := StrToFloat(Cells[1, NDIM + 2]);
    for I := 1 to NDIM do      YS[I] := StrToFloat(Cells[2,    1 + I]);
                               QMODS := StrToFloat(Cells[2, NDIM + 2]);
    for I := 1 to NDIM do      HL[I] := StrToFloat(Cells[3,    1 + I]);
    for I := 1 to NDIM do      HR[I] := StrToFloat(Cells[4,    1 + I]);
    for I := 1 to NDIM do      HY[I] := StrToFloat(Cells[5,    1 + I]);
  end;

  with Form1 do                                //-------------------Grap_Input
  begin
     //ShowMessage('Calc_Draw: Grap_Input');
     XMIN  := StrToFloat(eXMin.Text);
     XMAX  := StrToFloat(eXMax.Text);
     QMIN  := StrToFloat(eQMin.Text);      //ShowMessage('QMIN  = ' + FloatToStr(QMIN));
     QMAX  := StrToFloat(eQMax.Text);      //ShowMessage('QMAX  = ' + FloatToStr(QMAX));
     QSOLV := StrToFloat(eQSOLV.Text);
     NIC[1] := StrToInt(NuCo_L1.Text);     // -  
     ICL[1] := StrToFloat(eMin_L1.Text);
     ICR[1] := StrToFloat(eMax_L1.Text);
     NIC[2] := StrToInt(NuCo_L2.Text);    if NuCo_L2.Text = '0' then goto M10;
     ICL[2] := StrToFloat(eMin_L2.Text);
     ICR[2] := StrToFloat(eMax_L2.Text);
M10: NIC[3] := StrToInt(NuCo_L3.Text);    if NuCo_L3.Text = '0' then goto M20;
     ICL[3] := StrToFloat(eMin_L3.Text);
     ICR[3] := StrToFloat(eMax_L3.Text);
M20: NJC[1] := StrToInt(NuCo_L4.Text);    if NuCo_L4.Text = '0' then goto M30;
     JCL[1] := StrToFloat(eMin_L4.Text);
     JCR[1] := StrToFloat(eMax_L4.Text);
M30: NJC[2] := StrToInt(NuCo_L5.Text);    if NuCo_L5.Text = '0' then goto M40;
     JCL[2] := StrToFloat(eMin_L5.Text);
     JCR[2] := StrToFloat(eMax_L5.Text);
M40: NKC[1] := StrToInt(NuCo_P1.Text);    // -  
     KCL[1] := StrToFloat(eMin_P1.Text);
     KCR[1] := StrToFloat(eMax_P1.Text);
     NKC[2] := StrToInt(NuCo_P2.Text);    if NuCo_P2.Text = '0' then goto M50;   //ShowMessage('NKC[2] = ' + IntToStr(NKC[2]));
     KCL[2] := StrToFloat(eMin_P2.Text);
     KCR[2] := StrToFloat(eMax_P2.Text);
M50: end;

  //   
  for I := 1 to N5 do    // -   0-  2- 
//    D[I] := (I - 1) / NDEL;
    D[I] := XMIN + (XMAX - XMIN) * (I - 1) / NDEL;

  case INAP of
    0:                               // - 
      for I := 1 to N5 do
        for K := 1 to NDIM do
          V[I, K] := HY[K];
    1:                               // - 
      begin
        AssignFile(fTABL, 'fTABL.rsl');    Reset(fTABL);    readln(fTABL, Str);
        for I := 1 to N5 do
        begin
          read(fTABL, D[I]);
          for J := 1 to NDIM do
            read(fTABL, V[I, J]);
        end;
        CloseFile(fTABL);
      end;
    2, 3:                        // - : 2 -  , 3 -    INAPP()
      begin
        INAPP(N5, NDIM, INAP, D, V);
      end;
  end;
                          CIm[0] :=   Wid_Lev / (XMAX   - XMIN);                     //  
                          CIm[1] := - Hei_Lev / (ICR[1] - ICL[1]);
      if NIC[2] <> 0 then CIm[2] := - Hei_Lev / (ICR[2] - ICL[2]);
      if NIC[3] <> 0 then CIm[3] := - Hei_Lev / (ICR[3] - ICL[3]);
      if NJC[1] <> 0 then CJm[1] := - Hei_Lev / (JCR[1] - JCL[1]);
      if NJC[2] <> 0 then CJm[2] := - Hei_Lev / (JCR[2] - JCL[2]);
                          CKm[0] :=   Wid_Lev / (QMAX   - QMIN);
                          CKm[1] := - Hei_Lev / (KCR[1] - KCL[1]);
      if NKC[2] <> 0 then CKm[2] := - Hei_Lev / (KCR[2] - KCL[2]);
                                                                        //ShowMessage('CIm[2] = ' + FloatToStr(CIm[2]));
//-----------------------------------------------------------------------------------   
//-----------------------------------------------------------------------------------   
      //ShowMessage('  ');
  IREG := 0;
  for I := 1 to N5 do
  begin
    //ShowMessage('I = ' + IntToStr(I));
    //ShowMessage('D[' + IntToStr(I) + '] = ' + FloatToStr(D[I]));
    for J := 1 to NDIM do
    begin
      //ShowMessage('J = ' + IntToStr(J));
      //ShowMessage('V[' + IntToStr(I) + ', ' + IntToStr(J) + '] = ' + FloatToStr(V[I, J]));
      //ShowMessage('HL[' + IntToStr(J) + '] = ' + FloatToStr(HL[J]));
      //ShowMessage('HR[' + IntToStr(J) + '] = ' + FloatToStr(HR[J]));
      if (V[I, J] < HL[J]) or (V[I, J] > HR[J]) then
      begin
        IREG := 1;    ShowMessage('0_IREG = ' + IntToStr(IREG));
        //ShowMessage('I = ' + IntToStr(I));    ShowMessage('J = ' + IntToStr(J));
        //ShowMessage('V[' + IntToStr(I) + ', ' + IntToStr(J) + '] = ' + FloatToStr(V[I, J]));
      end;
    end;
  end;
      //ShowMessage('1_IREG = ' + IntToStr(IREG));
  if (QMOD < QMIN) or (QMOD > QMAX) then IREG := 1;
      //ShowMessage('2_IREG = ' + IntToStr(IREG));
  if IREG = 0 then Goto L100
  else
  begin
        Form4.Left    := Form1.Left + 417;
        Form4.Top     := Form1.Top  + 548;
    Form4.Button1.Caption := 'i1=0, ireg=1, end';
    Form4.ShowModal;
    Message_Exit();    Exit;    end;

  //        
  //---------------------------------------------------
L100:
  if (I6 = NSTEP) and (I0 = 0) then goto L101 else goto L102;
L101:
  DELTA();                                                                        //---------------------- DELTA
      //ShowMessage('posle_DELTA()');

if ISTEP < 3 then ShowMessage('L101_ISTEP = ' + IntToStr(ISTEP));

L102:
  if BON = 0 then BOND(NDIM, 2 * NDIM, N5, V, G) else BONDN();                    //----------------- BOND (BONDN)
  IC_ := 1;    D_ := D[1];
  for K := 1 to NDIM do
    Q[K] := V[IC_, K];
  if JAC = 0 then JACOB(NDIM, D_, QMOD, Q, O, R, U) else JACOBN();                //-------------- JACOB_ (JACOBN)

  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM do
      T[K, J] := U[K, J];
    X[K, 1] := O[K];    X[K, 3] := R[K];
  end;
L110:
  D_ := D[IC_ + 1];    H0 := D_ - D[IC_];    H1 := 0.5 * H0;    H2 := 0.1666667 * H0;    H3 := 0.125 * H0;
  for K := 1 to NDIM do
    Q[K] := V[IC_ + 1, K];

  if JAC = 0 then JACOB(NDIM, D_, QMOD, Q, O, R, U) else JACOBN();                //-------------- JACOB_ (JACOBN)
  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM do
      T[K, NDIM + J] := U[K, J];
    Q[K] := 0.5 * (V[IC_, K] + Q[K]) + H3 * (X[K, 1] - O[K]);    X[K, 2] := O[K];    X[K, 4] := R[K];
  end;
  D_ := 0.5 * (D_ + D[IC_]);
  if JAC = 0 then JACOB(NDIM, D_, QMOD, Q, O, R, U) else JACOBN();                //-------------- JACOB_ (JACOBN)
  for K := 1 to NDIM do
  begin
    C0 := 0;
      for J := 1 to NDIM do
      begin
        C1 := 0;    C2 := 0;
        for M := 1 to NDIM do
        begin
          C1 := C1 + U[K, M] * T[M, J];    C2 := C2 + U[K, M] * T[M, NDIM + J];
        end;    // M
        E_[K, J] := H2 * (T[K, J] + 2 * U[K, J] + H1 * C1);
        E_[K, NDIM + J] := H2 * (T[K, NDIM + J] + 2 * U[K, J] - H1 * C2);
        C0 := C0 + U[K, J] * (X[J, 3] - X[J, 4]);
      end;    // J
      E_[K, K] := E_[K, K] + 1;
      E_[K, NDIM + K] := E_[K, NDIM + K] - 1;
      FFF := H2 * (X[K, 1] + 4 * O[K] + X[K, 2]);
      F[IC_ + N5, K] := V[IC_, K] - V[IC_ + 1, K] + FFF;
      F[IC_, K] := H2 * (X[K, 3] + 4 * R[K] + X[K, 4] + H1 * C0);
  end;    // K
  for K := 1 to NDIM do
  begin
    K1 := 2 * NDIM * (K - 1);    K2 := K1 + NDIM;
    for J := 1 to NDIM do
    begin
      A[IC_, K1 + J] := E_[K, J];    A[IC_, K2 + J] := E_[K, NDIM + J];    T[K, J] := T[K, J + NDIM];
    end;
    X[K, 1] := X[K, 2];    X[K, 3] := X[K, 4];
  end;
  IC_ := IC_ + 1;    if IC_ = N5 then goto L200 else goto L110;

  //         
  //--------------------------------------------------------------
L200:
  if (IIND < NDEL + 2) then L0 := 3 else L0 := 2;
  L9 := 3 * NDIM;
  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM do
    begin
      W[K, J] := G[K, J];    W[K, J + 2 * NDIM] := G[K, J + NDIM];
    end;    // J
    W[K, L9 + 1] := G[K, 2 * NDIM + 1];    W[K, L9 + 2] := G[K, 2 * NDIM + 2];    W[K, L9 + 3] := 0;
  end;    // K
  if (L0 = 2) then goto L210;
  for I := 1 to NDEL do
    for K := 1 to NDIM do
      F[I + 2 * N5, K] := 0;
  J0 := JIND + 1;
  if (IIND > 1) then goto L201;
  for K := 1 to NDIM do
  begin
    for J := J0 to NDIM do
      W[K, J - 1] := W[K, J];
    W[K, NDIM] := 0;    W[K, L9 + 3] := G[K, JIND];
  end;    // K
L201:
  if (IIND = N5) then goto L202;
  for K := 1 to NDIM do
  begin
    K1 := 2 * NDIM * (K - 1);
    F[2 * N5 + IIND, K] := A[IIND, K1 + JIND];
    for J:= J0 to 2 * NDIM do
      A[IIND, K1 + J - 1] := A[IIND, K1 + J];
    A[IIND, K1 + 2 * NDIM] := 0;
  end;    // K
  if (IIND = 1) then goto L210;
L202:
  for K := 1 to NDIM do
  begin
    K2 := 2 * NDIM * (K - 1) + NDIM;
    F[IIND - 1 + 2 * N5, K] := A[IIND - 1, K2 + JIND];
    for J := J0 to NDIM do
      A[IIND - 1, K2 + J - 1] := A[IIND - 1, K2 + J];
    A[IIND - 1, K2 + NDIM] := 0;
  end;    // K
  if (IIND < N5) then goto L210;
  for K := 1 to NDIM do
  begin
    for J := J0 to NDIM do
      W[K, J + 2 * NDIM - 1] := W[K, J + 2 * NDIM];
    W[K, L9 + 3] := G[K, JIND + NDIM];    W[K, L9] := 0;
  end;    // K
L210:
  N3 := L9 + L0;
  for I := 1 to NDEL do
  begin
    if I > IIND then M8 := N1 else M8 := NDIM;
    for K := 1 to M8 do
      for J := N1 to 2 * NDIM do
        W[K, J] := 0;
    for K := 1 to NDIM do
    begin
      K1 := 2 * NDIM * (K - 1);
      for J := 1 to 2 * NDIM do
        W[K + M8, J] := A[I, K1 + J];
      for J := 1 to NDIM do
        W[K + M8, 2 * NDIM + J] := 0;
      for M := 1 to L0 do
        W[K + M8, L9 + M] := F[I + N5 * (M - 1), K];
    end;    // K
    if I = IIND then L1 := NDIM - 1 else L1 := NDIM;
    N4 := NDIM + M8;
    if (I < NDEL) then
    begin
      GAUSS();                                                                    //---------------------- GAUSS
      for K := 1 to L1 do
      begin
        K1 := 2 * NDIM * (K - 1);    K2 := NDIM * (K - 1);
        for J := 1 to 2 * NDIM do
          A[I, K1 + J]:= W[K, J];
        for J := 1 to NDIM do
          B[I, K2 + J] := W[K, 2 * NDIM + J];
        for M := 1 to L0 do
          F[I + N5 * (M - 1), K] := W[K, L9 + M];
        if (L0 = 2) then F[I + 2 * N5, K] := F[I, K];
      end;    // K
      if I < IIND then M9 := NDIM else M9 := N1;
      for K := 1 to M9 do
      begin
        for J := 1 to NDIM do
        begin
          W[K, J] := W[L1 + K, L1 + J];    W[K, J + 2 * NDIM] := W[L1 + K, 2 * NDIM + J];
        end;
        for M := 1 to L0 do
          W[K, L9 + M] := W[L1 + K, L9 + M];
      end;    // K
    end;    // if (I < N)
  end;    // I
  N3 := N3 - NDIM;    L1 := N4;
  for K := 1 to M8 do
    for J := N1 to N3 do
      W[K, J] := W[K, J + NDIM];
  for K := 1 to NDIM do
    for M := 1 to L0 do
      W[K + M8, 2 * NDIM + M] := W[K + M8, L9 + M];
  if (IIND < NDEL) or (L0 = 2) then goto L212;
  N3 := 2 * NDIM + 2;
  if (IIND = N5) then goto L211;
  for K := 1 to NDIM do
  begin
    for J := NDIM to N3 do
      W[K, J] := W[K, J + 1];
    for M := 1 to 3 do
      W[K + NDIM, 2 * NDIM + M - 1] := W[K + NDIM, 2 * NDIM + M];
  end;    // K
  GOTO L212;
L211:
  for K := 1 to 2 * NDIM do
    for J := 2 * NDIM to N3 do
      W[K, J] := W[K, J + 1];
L212:
  GAUSS();                                                                        //---------------------- GAUSS
  if (IIND = N5) or (IIND = NDEL) then MK1 := 1 else MK1 := 0;
  if (IIND < NDEL) then MM2 := 1  else MM2 := 0;
  if (L0 = 2)   then MM3 := 1  else MM3 := 0;
  MK2 := MM2 - MM3;

  for M := 1 to K9 do
  begin
    if (M = 1) then L := 2 * NDIM + 2 - MK1 else L := 2 * NDIM + 2 + MK2;
      W[N4, L] := W[N4, L] / W[N4, N4];
    for K := N4 - 1 downto 1 do
    begin
      C0 := W[K, L];
      for J := N4 downto K + 1 do
        C0 := C0 - W[K, J] * W[J, L];
      W[K, L] := C0 / W[K, K];
    end;    // K
    if (IIND = NDEL) then L4 := NDIM - 1 else L4 := NDIM;
    for K := 1 to L4 do
      F[NDEL + N5 * M, K] := W[K, L];
    if (IIND = N5) then L5:= NDIM - 1 else L5:= NDIM;
    for K := 1 to L5 do
      F[N5 + N5 * M, K] := W[K + L4, L];
    if (M = 2) then Q[2 * NDIM + M] := -1 else Q[2 * NDIM + M] := 0;
    if (L0 = 2) then goto L213;
    Q[2 * NDIM + M] := W[N4, L];
L213:
    for I := 1 to NDEL - 1 do
    begin
      if (I = IIND) then L1 := NDIM - 1 else L1 := NDIM;
      M7 := I + N5 * M;
      for K := 1 to L1 do
      begin
        C0 := F[M7, K];
        if (IIND < N5) or (L0 = 2) then goto L214;
        B[I, NDIM * K] := F[I, K];
L214:
        K1 := NDIM * (K - 1);
        for J := 1 to NDIM do
          C0 := C0 - B[I, K1 + J] * W[L4 + J, L];
        if (IIND > NDEL) then goto L215;
        C0 := C0 - F[I, K] * W[N4, L];
L215:
        F[M7, K] := C0;
      end;    // K
    end;    // I
    for I := NDEL - 1 downto 1 do
    begin
      if (I = IIND) then L1 := NDIM - 1 else L1 := NDIM;
      L2 := 2 * NDIM * (L1 - 1) + L1;
      if (I = IIND - 1) then L3 := NDIM - 1 else L3 := NDIM;
      M7 := I + N5 * M;
      for K := 1 to L1 do
      begin
        K1 := 2 * NDIM * (K - 1) + L1;
        C0 := F[M7, K];
        for J := 1 to L3 do
          C0 := C0 - A[I, K1 + J] * F[M7 + 1, J];
        F[M7, K] := C0;
      end;    // K

      F[M7, L1] := F[M7, L1] / A[I, L2];
      for K := L1 - 1 downto 1 do
      begin
        C0 := F[M7, K];    K3 := 2 * NDIM * (K - 1);
        for J := L1 downto K + 1 do
          C0 := C0 - A[I, K3 + J] * F[M7, J];
        F[M7, K] := C0 / A[I, K3 + K];
      end;    // K
    end;    // I
    if (L0 = 3) then
    begin
      M7 := IIND + N5 * M;
      for K := NDIM downto J0 do
        F[M7, K] := F[M7, K - 1];
      if (M = 2) then F[M7, JIND] := -1 else F[M7, JIND] := 0;
    end;    // if
  end;    // M

  //         
  //--------------------------------------------------------------
  C9 := ABS(Q[2 * NDIM + 1]);    C0 := ABS(QMOD);
  for I := 1 to N5 do
    for K := 1 to NDIM do
    begin
      if (C9 < ABS(F[I + N5, K])) then C9 := ABS(F[I + N5, K]);
      if (C0 < ABS(V[I, K])) then C0 := ABS(V[I, K]);
      V[I, K] := V[I, K] - F[I + N5, K];
    end;
  QMOD := QMOD - Q[2 * NDIM + 1];
  if (C0 > 1) then C9 := C9 / C0;
  if (C9 < EXACT) and (K9 = 2) then Goto L311;
  I0 := I0 + 1;

  MARK_ := 1;    Print();                                                         //------------ Print

  IF C9 > EXACT THEN Goto L300;
  K9 := 2;    GOTO L100;
L300:
  K9 := 1;
  IF (I0 > LIM) THEN Goto L301 ELSE GOTO L100;
L301:
  IF I1 > 0 THEN Goto L302;
  IF I0 < LIM0 THEN Goto L100;
L302:
  H7 := H7 / 2;
  IF ABS(H7) < EMIN * H5 THEN
  begin
    Form4.Button1.Caption := 'iter, abs(H7)<EMIN*H5, end';
    Form4.ShowModal;
    Message_Exit();    Exit;    END;

  //       
  //---------------------------------------------------------------------
L310:
  I0 := 0;
  IF (I1 = 1) THEN
  begin
    For I := 1 TO N5 do
      For K := 1 TO NDIM do
        V[I, K] := Y[I + N5, K] + H7 * P[I + N5, K];
    QMOD := Q8 + H7 * P8;
    GOTO L100;
  END;    // if
  R_ := H7 / H6;    //    'R_  R
  For I := 1 TO N5 do
    For K := 1 TO NDIM do
    begin
      F1 := P[I + N5, K] + P[I, K] - 2 * (Y[I + N5, K] - Y[I, K]) / H6;
      F2 := F1 + P[I + N5, K] - (Y[I + N5, K] - Y[I, K]) / H6;
      V[I, K] := Y[I + N5, K] + H7 * (P[I + N5, K] + R_ * (F2 + R_ * F1));
    end;    // K
  F1 := P8 + P7 - 2 * (Q8 - Q7) / H6;    F2 := F1 + P8 - (Q8 - Q7) / H6;
  QMOD := Q8 + H7 * (P8 + R_ * (F2 + R_ * F1));
  GOTO L100;
L311:
  IF (QMOD < QMIN) OR (QMOD > QMAX) THEN
  begin
    Form4.Button1.Caption := 'Qmod < Qmin or Qmod > Qmax';
    Form4.ShowModal;
    Message_Exit();    Exit;    end;

  IREG := 0;
  For I := 1 TO N5 do
    For J := 1 TO NDIM do
      IF (V[I, J] < HL[J]) OR (V[I, J] > HR[J]) THEN IREG := 1;

  IF IREG = 1 THEN Goto L312;
  IF K9 = 2 THEN Goto L314 ELSE GOTO L100;
L312:
  IF I1 > 0 THEN Goto L313
  else
  begin
    Form4.Button1.Caption := 'i1=0, ireg=1, end';
    Form4.ShowModal;
    Message_Exit();    Exit;    end;

L313:
  H7 := H7 / 2;    IF ABS(H7) > EMIN * H5 THEN Goto L310;

  writeln(fTABL_Bif, '');                                                   // ------------------------- fTABL_Bif
  writeln(fTABL_Bif, '  IBIF  = ' + IntToStr(IBIF));
  writeln(fTABL_Bif, '');
  writeln(fTABL_Bif, '  QMOD  = ' + FloatToStrF(QMOD, ffexponent, 6, 2));
  writeln(fTABL_Bif, '');
        Str1 := '    D(I)       YI,' + IntToStr(NIC[1]) + ')';
        if NIC[2] <> 0 then Str1 := Str1 + '       Y(I,' + IntToStr(NIC[2]) + ')';
        if NIC[3] <> 0 then Str1 := Str1 + '       Y(I,' + IntToStr(NIC[3]) + ')';
        writeln(fTABL_Bif, Str1);
        Str2 := ' +---------+------------+';
        if NIC[2] <> 0 then Str2 := Str2 + '------------+';
        if NIC[3] <> 0 then Str2 := Str2 + '------------+';
        writeln(fTABL_Bif, Str2);
        for I := 1 to N5 do
        begin
          Str1 := '  ' + FloatToStrF(D[I], ffexponent, 3, 2);
          if Y[I, NIC[1]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[1]], ffexponent, 6, 2)
          else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[1]], ffexponent, 5, 2);
          if NIC[2] <> 0 then
            if Y[I, NIC[2]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[2]], ffexponent, 6, 2)
            else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[2]], ffexponent, 5, 2);
          if NIC[3] <> 0 then
            if Y[I, NIC[3]] >= 0 then Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[3]], ffexponent, 6, 2)
            else                      Str1 := Str1 + '  ' + FloatToStrF(Y[I, NIC[3]], ffexponent, 5, 2);
          writeln(fTABL_Bif, Str1);
        end;

  Form4.Button1.Caption := 'ireg, abs(H7)<EMIN*H5, end';
  Form4.ShowModal;

  Message_Exit();    Exit;

L314:
  IF I1 = 0 THEN Goto L328;

  //       Q=QSOLV    
  //---------------------------------------------------------------------
  H := QMOD - Q8;
  IF JIND = 0 THEN Goto L320;
  H := V[IIND, JIND] - Y[IIND + N5, JIND];
L320:
  KSOLV := SIGN(QSOLV - QMOD) - SIGN(QSOLV - Q8);
  IF (KSOLV = 0) OR (Q8 = QSOLV) THEN Goto L324;
  T1 := 0;    T2 := 1;    R1 := Q8 - QSOLV;    R2 := QMOD - QSOLV;
L321:
  IF (T2 - T1 < 0.00001) OR (T2 < T1) THEN Goto L323;
  T_ := 0.5 * (T1 + T2);    TT := 1 + 2 * T_;    HT := H * T_ * (1 - T_);
  R0 := Q8 * TT * Sqr(1 - T_) + QMOD * (3 - 2 * T_) * T_ * T_;
  R0 := R0 + HT * ((1 - T_) * P8 + T_ * Q[2 * NDIM + 2]) - QSOLV;
  IF SIGN(R0) = SIGN(R2) THEN Goto L322;
  R1 := R0;    T1 := T_;    GOTO L321;
L322:
  R2 := R0;    T2 := T_;    GOTO L321;
L323:
  ISOLV := ISOLV + 1;
  SPLINE();                                                                       //------------ SPLINE
  MARK_ := 3;    PRINT();                                                         //------------ PRINT

L324:
  KSOLV := SIGN(Q[2 * NDIM + 2]) + SIGN(P8);
  IF KSOLV = 0 THEN Goto L328;
  T1 := 0;    T2 := 1;    R1 := P8;    R2 := -Q[2 * NDIM + 2];
L325:
  IF (T2 - T1 < 0.00001) OR (T2 < T1) THEN Goto L327;
  T_ := 0.5 * (T1 + T2);    TT := T_ * (2 - 3 * T_);
  R0 := 6 * T_ * (1 - T_) * (QMOD - Q8) / H;
  R0 := R0 + (1 - T_) * (1 - 3 * T_) * P8 + TT * Q[2 * NDIM + 2];
  IF SIGN(R0) = SIGN(R2) THEN Goto L326;
  R1 := R0;    T1 := T_;    GOTO L325;
L326:
  R2 := R0;    T2 := T_;    GOTO L325;
L327:
  IBIF := IBIF + 1;
  SPLINE();

  MARK_ := 4;    PRINT();                                                         //------------ PRINT

L328:
  if ADF = 1 then ADFUN(N5, QMOD, V, W1D);
                               //ShowMessage('W1D[1, 1] = ' + FloatToStr(W1D[1, 1]));
                               //ShowMessage('W1D[2, 1] = ' + FloatToStr(W1D[2, 1]));
  MARK_ := 2;    PRINT();                                                         //------------ PRINT

  BIFC(IStep, N5, QMOD, V, NKC, BFX, BF1, BF2);                                   //------------ BIFC

  //         
  //---------------------------------------------------------------------
  K9 := 1;    Q[2 * NDIM + 2] := -Q[2 * NDIM + 2];
  For I := 1 TO N5 do
    For K := 1 TO NDIM do
      F[I + 2 * N5, K] := -F[I + 2 * N5, K];
  C0 := 0;
  IF IPAR = N1 THEN Goto L332;
  IF (IPAR > 0) AND (IPAR < N1) THEN Goto L334;
  For I := 1 TO N5 do
    For K := 1 TO NDIM do
    begin
      IF ABS(F[I + 2 * N5, K]) / YS[K] < ABS(C0) THEN Goto L331;
      IIND := I;    JIND := K;    C0 := F[I + 2 * N5, K] / YS[K];
L331:
    end;    // K
  IF IPAR > N1 THEN Goto L333;
  IF (ABS(Q[2 * NDIM + 2]) / QMODS < ABS(C0)) THEN Goto L333;
L332:
  IIND := NDEL + 2;    JIND := 0;    C0 := Q[2 * NDIM + 2];    GOTO L336;
L333:
  C0 := C0 * YS[JIND];    GOTO L336;
L334:
  For I := 1 TO N5 do
  begin
    IF ABS(F[I + 2 * N5, IPAR]) < ABS(C0) THEN Goto L335;
    IIND := I;    C0 := F[I + 2 * N5, IPAR];
L335:
    JIND := IPAR;
  end;    //I
L336:
  For I := 1 TO N5 do
    For K := 1 TO NDIM do
      F[I + 2 * N5, K] := F[I + 2 * N5, K] / C0;
  Q[2 * NDIM + 2] := Q[2 * NDIM + 2] / C0;

  //       
  //---------------------------------------------------------------------
  IF I1 > 0 THEN Goto L342;
  IF I6 = NSTEP THEN Goto L338;
  IF IIND = NDEL + 2 THEN Goto L337;
  H7 := HV[JIND];    H5 := H7;    GOTO L338;
L337:
  H7 := QSTEP;    H5 := HMOD;
L338:
  IF J8 = 0 THEN Goto L339;
  P_ := F[I8 + 2 * N5, J8] * H7;    GOTO L340;
L339:
  P_ := Q[2 * NDIM + 2] * H7;
L340:
  IF SIGN(P_) = DIREC THEN Goto L341;
  H7 := -H7;
L341:
  For I := 1 TO N5 do
    For K := 1 TO NDIM do
    begin
      Y[I + N5, K] := V[I, K];    P[I + N5, K] := F[I + 2 * N5, K];
    end;    // K
  Q8 := QMOD;    P8 := Q[2 * NDIM + 2];    GOTO L346;
L342:
  IF IIND = NDEL + 2 THEN Goto L343;
  P0 := P[IIND + N5, JIND];    H5 := HV[JIND];    H6 := V[IIND, JIND] - Y[IIND + N5, JIND];    GOTO L344;
L343:
  P0 := P8;    H5 := HMOD;    H6 := QMOD - Q8;
L344:
  For I := 1 TO N5 do
    For K := 1 TO NDIM do
    begin
      Y[I, K]      := Y[I + N5, K];    P[I, K]      := P[I + N5, K] / P0;
      Y[I + N5, K] := V[I, K];         P[I + N5, K] := F[I + 2 * N5, K];
    end;    // K
  Q7 := Q8;    P7 := P8 / P0;    Q8 := QMOD;    P8 := Q[2 * NDIM + 2];    H7 := ACCEL * H6;
  IF ABS(H7) < EMAX * H5 THEN Goto L345;
  H7 := EMAX * H5 * SIGN(H6);
L345:
  IF I1 >= NSTEP THEN Goto L347;
L346:
  I1 := I1 + 1;    I6 := 0;

    XX1 := round(CKm[0] * (BFX[ISTEP]     - QMIN));
    XX2 := round(CKm[0] * (BFX[ISTEP + 1] - QMIN));
    f11 := round(CKm[1] * (BF1[ISTEP]     - KCR[1]));
    f12 := round(CKm[1] * (BF1[ISTEP + 1] - KCR[1]));
  if NKC[2] <> 0 then
  begin
    f21 := round(CKm[2] * (BF2[ISTEP]     - KCR[2]));
    f22 := round(CKm[2] * (BF2[ISTEP + 1] - KCR[2]));
  end;

  XXSolv := round(CKm[0] * (QSOLV - QMIN));
  with BitMapP.Canvas do
  begin
    Pen.Style := psSolid;    Pen.Width := 2;
    Pen.Color := Col1[3];    MoveTo(XXSolv, 0);    LineTo(XXSolv, Hei_Lev);
    Pen.Color := Col1[1];    //MoveTo(XX1, f11);     LineTo(XX2, f12);    - - VdP  0-
    if (ISTEP >= 1) then
    begin
      MoveTo(XX1, f11);     LineTo(XX2, f12);
    end;
    //if NKC[2] <> 0 then                                                 - - VdP  0-
    if (NKC[2] <> 0) and (ISTEP >= 1) then
    begin
      Pen.Color := Col1[2];    MoveTo(XX1, f21);     LineTo(XX2, f22);
    end;
  end;
  Form1.PaintBox2.Canvas.Draw(0,0,BitMapP);

  if ISTEP > 0 then writeln(fTABL_Mul, Format('%6d', [ISTEP]), '  ' + FloatToStrF(BFX[ISTEP], ffexponent, 6, 2) +
                                                               '  ' + FloatToStrF(BF1[ISTEP], ffexponent, 6, 2) +
                                                               '  ' + FloatToStrF(BF2[ISTEP], ffexponent, 6, 2));
  ISTEP := ISTEP + 1;    //ShowMessage('ISTEP = ' + IntToStr(ISTEP));

  Form1.lQmod.Caption  := FloatToStrF(QMOD, ffexponent, 3, 2);
  Form1.lStepN.Caption := IntToStr(ISTEP);
  Form1.lIndex.Caption := IntToStr(IIND) + ', ' + IntToStr(JIND);
  Form1.lInacc.Caption := FloatToStrF(C9, ffexponent, 3, 2);

  IF ISTEP <= NEND THEN
    Goto L310
  ELSE
  begin
    if NEND > NBIF then
    begin
      ShowMessage('NEND > NBIF');    Message_Exit();    exit;
    end
    else
    begin
      Sib := InputBox('   NBIF = ' + IntToStr(NBIF) + ',   NEND = ' + IntToStr(NEND), '   Input dNEND: ', '0');
      dNEND := StrToInt(Sib);
      if dNEND = 0 then
      begin
        Message_Exit();    exit;     end;
      NEND := NEND + dNEND;    //ShowMessage('NEND = ' + IntToStr(NEND));
      Goto L310;
    end;
  end;

L347:
  C0 := 0;    IN_ := 1;
  For I := 1 TO N5 do    //STEP N
  begin
    if I < IN_ then continue;
    For K := 1 TO NDIM do
    begin
      IF ABS(P[IN_ + N5, K]) < C0 THEN continue;
      I8 := IN_;    J8 := K;    C0 := ABS(P[IN_ + N5, K]);
    end;    // K
    IN_ := IN_ + NDEL;
  end;    // I
  DIREC := SIGN(H7 * P[I8 + N5, J8]);
  IF ABS(P8) < C0 THEN Goto L349;
  I8 := NDEL + 2;    J8 := 0;    C0 := ABS(P8);    DIREC := SIGN(H7 * P8);
L349:
  IF C0 < EX0 THEN Goto L346;
  I6 := NSTEP;    I0 := 0;    I1 := 0;    GOTO L100;
end;    // Calc_Draw
//------------------------------------------------------------------------------------   
//------------------------------------------------------------------------------------   


//------------------------------------------------------------------ Calc_Run - Calc_Run - Calc_Run - Calc_Run
procedure TForm1.tbb_Calc_RunClick(Sender: TObject);
var
  NameLib: PChar;
begin
   GridP();
  if ModelName = '' then
  begin
    ShowMessage('Choose model from list (bookmark ''Equations'')');    Exit;
  end;
  NameLib := PChar(ModelDir + '\Special.dll');
  HandleLib := LoadLibrary(NameLib);

  if HandleLib = 0 then
    begin
      ShowMessage('  DLL');   Exit;
    end
  else
    begin
      @Renam  := GetProcAddress(HandleLib,'RENAM');
      if @Renam = NIL then
        begin
          ShowMessage('  Renam');   Exit;
        end;
      @Bond  := GetProcAddress(HandleLib,'BOND');
      if @Bond = NIL then
        begin
          ShowMessage('  Bond');   Exit;
        end;
      @ListB  := GetProcAddress(HandleLib,'LISTB');
      if @ListB = NIL then
        begin
          ShowMessage('  ListB');   Exit;
        end;
      @Jacob  := GetProcAddress(HandleLib,'JACOB');
      if @Jacob = NIL then
        begin
          ShowMessage('  Jacob');   Exit;
        end;
      @ListJ  := GetProcAddress(HandleLib,'LISTJ');
      if @ListJ = NIL then
        begin
          ShowMessage('  ListJ');   Exit;
        end;
      @BifC  := GetProcAddress(HandleLib,'BIFC');
      if @BifC = NIL then
        begin
          ShowMessage('  BifC');   Exit;
        end;
      @INAPP  := GetProcAddress(HandleLib,'INAPP');
      if @BifC = NIL then
        begin
          ShowMessage('  INAPP');   Exit;
        end;
      @ADFUN  := GetProcAddress(HandleLib,'ADFUN');
      if @BifC = NIL then
        begin
          ShowMessage('  ADFUN');   Exit;
        end;
    end;
  //ShowMessage('tbb_Calc_Run');
  //----------------------------
  Assign_File();    Calc_Draw();
  //----------------------------
end;


//------------------------------------------------------------------- Calc_Grap_Read
procedure TForm1.tbb_Calc_ReadClick(Sender: TObject);
var
  FName : String;
begin
  with OpenDialog1 do    begin    InitialDir := ModelDir;
    Filter     := 'Grap_Param*.ish|Grap_Param*.ish|All  Files (*.*)|*.*';
    FileName   := 'Grap_Param.ish';
    if Execute then    begin
      FName := FileName;                     Grap_Param_Read(FName);
      Delete(FName, 1, Length(ModelDir));    StatusBar1.Panels[2].Text := FName;    end;    end;
end;


//------------------------------------------------------------------- Calc_Grap_Save
procedure TForm1.tbb_Calc_SaveClick(Sender: TObject);
var
  tf : TextFile;    FName : String;    I : Integer;
begin
  with SaveDialog1 do
  begin
    InitialDir := ModelDir;
    Filter     := 'Grap_Param*.ish|Grap_Param*.ish';    DefaultExt := '.ish';    FileName   := 'Grap_Param.ish';
    if Execute then
    begin
      FName := FileName;    AssignFile(tf, FName);    Rewrite(tf);
      writeln(tf, eXMin.Text);
      writeln(tf, eXMax.Text);
      writeln(tf, eQMin.Text);
      writeln(tf, eQMax.Text);
      writeln(tf, eQSOLV.Text);     writeln(tf, '');
      writeln(tf, NuCo_L1.Text);
      writeln(tf, eMin_L1.Text);
      writeln(tf, eMax_L1.Text);
      writeln(tf, NuCo_L2.Text);
      writeln(tf, eMin_L2.Text);
      writeln(tf, eMax_L2.Text);
      writeln(tf, NuCo_L3.Text);
      writeln(tf, eMin_L3.Text);
      writeln(tf, eMax_L3.Text);    writeln(tf, '');
      writeln(tf, NuCo_L4.Text);
      writeln(tf, eMin_L4.Text);
      writeln(tf, eMax_L4.Text);
      writeln(tf, NuCo_L5.Text);
      writeln(tf, eMin_L5.Text);
      writeln(tf, eMax_L5.Text);    writeln(tf, '');
      writeln(tf, NuCo_P1.Text);
      writeln(tf, eMin_P1.Text);
      writeln(tf, eMax_P1.Text);
      writeln(tf, NuCo_P2.Text);
      writeln(tf, eMin_P2.Text);
      writeln(tf, eMax_P2.Text);    writeln(tf, '');
      CloseFile(tf);
    end;
  end;
end;

//------------------------------------------------------------------- Calc_Clear
procedure TForm1.tbb_Calc_ClearClick(Sender: TObject);
begin
  GridL();    GridP();
  Form1.lQmod.Caption  := '';
  Form1.lStepN.Caption := '';
  Form1.lIndex.Caption := '';
  Form1.lInacc.Caption := '';
end;

//------------------------------------------------------------------- Calc_Help
procedure TForm1.tbb_Calc_HelpClick(Sender: TObject);
begin
  winhelp(Handle,'BPRQ_Help.hlp',HELP_CONTEXT,11);
end;

//------------------------------------------------------------------- Calc_Exit
procedure TForm1.tbb_Calc_ExitClick(Sender: TObject);
begin
  Close;    Form2.Show;
end;

//--------------------------------------------------------------------------------------- Tabl
//------------------------------------------------------------------- Tabl_Read
procedure TForm1.tbb_Tabl_ReadClick(Sender: TObject);
var
  OpenDlg : TOpenDialog;    FName : String;
begin
  OpenDlg := TOpenDialog.Create(Self);
  with OpenDlg do
  begin
    InitialDir := ModelDir;
    Filter     := 'Results Files (*.rsl)|*.rsl|All  Files (*.*)|*.*';
    if Execute then
    begin
      Memo_Tabl.Lines.LoadFromFile(FileName);
      FName := FileName;
      Delete(FName, 1, Length(ModelDir)+1);
      StatusBar1.Panels[1].Text := FName;
    end;
    Free;
  end;
end;


//------------------------------------------------------------------- Tabl_Clear
procedure TForm1.tbb_Tabl_ClearClick(Sender: TObject);
begin
  Memo_Tabl.Text := '';
end;

//------------------------------------------------------------------- Tabl_Help
procedure TForm1.tbb_Tabl_HelpClick(Sender: TObject);
begin
  winhelp(Handle,'BPRQ_Help.hlp',HELP_CONTEXT,12);
end;

//------------------------------------------------------------------- Tabl_Exit
procedure TForm1.tbb_Tabl_ExitClick(Sender: TObject);
begin
  Close;    Form2.Show;
end;

//------------------------------------------------------------------- FormClose
procedure TForm1.Problem1Click(Sender: TObject);
begin
  winhelp(Form1.Handle,'Probl.hlp', HELP_CONTEXT, 1);
end;




end.
