unit UProced;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ImgList, ExtCtrls, ToolWin, StdCtrls, Math, Grids, Menus,
  ShellApi; // !!!   ( Copy  Remove)

type
    TDelim = set of Char;
    TArrayOfString = Array of String;
    function fcToParts(sString : String; tdDelim : TDelim) : TArrayOfString;

    function WindowsCopyFile(FromFile, ToDir : string) : boolean;

    function MyRemoveDir(sDir : String) : Boolean;
var
  StrArr : TArrayOfString;    // -  'fcToParts' ( )
  NDIM, NPAR : Integer;

  procedure AddNewName();
  procedure Refresh_();
  procedure Delete_();

  procedure Read_Dimens(FName : String);
  procedure ComboBox1_Select();
  procedure SetLengthMass();

  procedure StringsGrid_Meth_Assign();
  procedure StringsGrid_Modl_Assign();
  procedure StringsGrid_Prob_Assign();
//  procedure StringsGrid_Grap_Assign();

  procedure Read_Meth();
  procedure Read_Modl();
  procedure Read_Prob();
  procedure Read_Grap();

  procedure Meth_Param_Read(FName : String);
  procedure Modl_Param_Read(FName : String);
  procedure Prob_Param_Read(FName : String);
  procedure Grap_Param_Read(FName : String);

  procedure GridL();
  procedure GridP();

  procedure Assign_File();

  procedure Template_();

  procedure Par_Nam_Save();

implementation

uses
  UGlobal, UMain, Start;


//********************************************************************************************************* <- functions
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++   (DRKB)
function fcToParts(sString : String; tdDelim : TDelim) : TArrayOfString;
var
  iCounter, iBegin : Integer;
begin
  if length(sString) > 0 then
  begin
      include(tdDelim, #0);    iBegin := 1;    SetLength(Result, 0);
    for iCounter := 1 to Length(sString)+1 do
    begin
      if (sString[iCounter] in tdDelim) then
      begin
        SetLength(Result, Length(Result)+1);
        Result[Length(Result)-1] := Copy(sString, iBegin, iCounter-iBegin);
        iBegin := iCounter+1;
      end;
    end;
  end;
end;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ WindowsCopyFile (DRKB)
function WindowsCopyFile(FromFile, ToDir : string) : boolean;
var F : TShFileOpStruct;
begin
  F.Wnd    := 0;                F.wFunc := FO_COPY;
  FromFile := FromFile + #0;    F.pFrom:=pchar(FromFile);
  ToDir    := ToDir + #0;       F.pTo := pchar(ToDir);
  F.fFlags := FOF_ALLOWUNDO or FOF_NOCONFIRMATION;
  result   := ShFileOperation(F) = 0;
end;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ MyRemoveDir (DRKB)
function MyRemoveDir(sDir : String) : Boolean;
var
  iIndex : Integer;    SearchRec : TSearchRec;    sFileName : String;
begin
  Result := False;    sDir := sDir + '\*.*';    iIndex := FindFirst(sDir, faAnyFile, SearchRec);
  while iIndex = 0 do
  begin
    sFileName := ExtractFileDir(sDir)+'\'+SearchRec.Name;
    if SearchRec.Attr = faDirectory then
    begin
      if (SearchRec.Name <> '' ) and (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
        MyRemoveDir(sFileName);
    end
    else
    begin
      if SearchRec.Attr <> faArchive then FileSetAttr(sFileName, faArchive);
      if NOT DeleteFile(sFileName) then ShowMessage('Could NOT delete ' + sFileName);
    end;
    iIndex := FindNext(SearchRec);
  end;
  FindClose(SearchRec);    RemoveDir(ExtractFileDir(sDir));    Result := True;
end;
//********************************************************************************************************* -> functions



//********************************************************************************************************* <- AddRefDel
//------------------------------------------------------------------------------ AddNewName
procedure AddNewName();
var
  I, NumMod : Integer;    f1 : TextFile;    StrM : String;    StrArr : TArrayOfString;
begin
  //1a)    :
  AssignFile(f1, CurDir + '\ModelsList.txt');    Reset(f1);
  NumMod := 0;
  repeat
    readln(f1, StrM);    //ShowMessage('StrM = _' + StrM + '_');
    if StrM <> '' then   NumMod := NumMod + 1;
  until EOF(f1) = True;
  CloseFile(f1);         //ShowMessage('NumMod = ' + IntToStr(NumMod));

  //1b)     :
  SetLength (StrArr, NumMod+1);     //ShowMessage('SetLength');
  AssignFile(f1, CurDir + '\ModelsList.txt');    Reset(f1);
  for I := 1 to NumMod do
    readln(f1, StrArr[I]);
  CloseFile(f1);

  //2)   'ModelsList.txt',  :
  AssignFile(f1, CurDir + '\ModelsList.txt');    Rewrite(f1);
  for I := 1 to NumMod do
    If StrArr[I] <> ModelName then writeln(f1, StrArr[I]);

  //3)   'ModelsList.txt':
  writeln(f1, ModelName);    CloseFile(f1);
//  ShowMessage('File  "ModelsList"  is complemented');
end;

//------------------------------------------------------------------------------ Refresh_
procedure Refresh_();
var
  f1 : TextFile;    StrM : String;
begin
  AssignFile(f1, CurDir + '\ModelsList.txt');    Reset(f1);
  //with Form1.cb_Equa do
  with Form2.cb_Equa do
  begin
    Items.Clear;
    repeat
      readln(f1, StrM);    if StrM <> '' then   Items.Add(StrM);
    until EOF(f1) = True;
  end;
  CloseFile(f1);
end;

//------------------------------------------------------------------------------ Delete_
procedure Delete_();
var
  StrM : String;    f1, f2 : TextFile;    NumMod : Integer;
begin
  if ModelName = '' then exit;
  
  AssignFile(f1, CurDir + '\ModelsList.txt');    Reset(f1);
  //   -   ?:
  NumMod := 0;
  repeat
    readln(f1, StrM);    //ShowMessage('StrM = _' + StrM + '_');
    if StrM <> '' then   NumMod := NumMod + 1;
  until EOF(f1) = True;
  CloseFile(f1);
  if NumMod = 1 Then
  begin
    ShowMessage('The last model cannot be deleted from the list!');    Exit;
  end;

  // :
  if (MessageDlg('Do you want to delete the model  "' + ModelName + '"?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo) then exit;

    DeleteFile(CurDir + '\' + ModelName + '\Special.dll');

  if MyRemoveDir(CurDir + '\' + ModelName) then
    ShowMessage('Directory  "' + ModelName + '"  is deleted');

  //  'ModelList.txt':
  //1)   ,  TaskName:
  AssignFile(f1, CurDir + '\ModelsList.txt');    Reset(f1);
  AssignFile(f2, CurDir + '\ModelsList_temp.txt');    Rewrite(f2);
  repeat
                               readln(f1, StrM);
    if StrM <> ModelName then writeln(f2, StrM);
  until EOF(f1) = True;
  CloseFile(f2);
  CloseFile(f1);

  //2)  ,  :
  AssignFile(f1, CurDir + '\ModelsList_temp.txt');    Reset(f1);
  AssignFile(f2, CurDir + '\ModelsList.txt');    Rewrite(f2);
  repeat
    readln(f1, StrM);    //ShowMessage('StrM = _' + StrM + '_');
    writeln(f2, StrM);
  until EOF(f1) = True;
  CloseFile(f2);    CloseFile(f1);

  //3) :
  Refresh_();
  //       'ComboBox1'       .
end;
//********************************************************************************************************* -> AddRefDel




//------------------------------------------------------------------ Read_Dimens
procedure Read_Dimens(FName : String);
var
  tf : TextFile;
begin
  if Not FileExists(FName) then    begin
    ShowMessage('File  "' + FName + '"  does not exist');    Exit;    end;
  AssignFile(tf, FName);    Reset(tf);
  //       .   - 
  readln(tf, NDIM);     Form2.ed_NDIM.Text := IntToStr(NDIM);    //ShowMessage('NDIM = ' + IntToStr(NDIM));
  readln(tf, NPAR);     Form2.ed_NPAR.Text := IntToStr(NPAR);    //ShowMessage('NPAR = ' + IntToStr(NPAR));
  //      ()
  readln(tf, NMAX);     Form2.ed_NMAX.Text := IntToStr(NMAX);    //ShowMessage('NMAX = ' + IntToStr(NMAX));
  readln(tf, NBIF);     Form2.ed_NBIF.Text := IntToStr(NBIF);    //ShowMessage('NBIF = ' + IntToStr(NBIF));
  //         (    )
  NPAR_div := NPAR div 10;                                       //ShowMessage('NPAR_div = ' + IntToStr(NPAR_div));
  NPAR_mod := NPAR mod 10;                                       //ShowMessage('NPAR_mod = ' + IntToStr(NPAR_mod));
    // -  !
  CloseFile(tf);
end;

//----------------------------------------------------------------------------------------------------- ComboBox1_Select
procedure ComboBox1_Select();    // -    !
var
  tf : TextFile;    FName : String;
begin
  ModelName := Form2.cb_Equa.Items.Strings[Form2.cb_Equa.ItemIndex];    //ShowMessage('ModelName = ' + ModelName);
  ModelDir := CurDir + '\' + ModelName;                                 //ShowMessage('ModelDir  = ' + ModelDir);
  FName := ModelDir + '\Dimens.ish';                                    //ShowMessage('FName     = ' + FName);

  Read_Dimens(FName);

  BitMapL.Free;    BitMapL := TBitMap.Create;    BitMapL.Width := 423;    BitMapL.Height := 461;
  BitMapP.Free;    BitMapP := TBitMap.Create;    BitMapP.Width := 423;    BitMapP.Height := 461;

  FName := ModelDir + '\Special.dpr';
  if Not FileExists(FName) then    begin
    ShowMessage('File  "' + FName + '"  does not exist');    Form1.Memo_Equa.Text := '';    Exit;    end;    //Form1.Memo_Equa.SetFocus;

  Form2.Memo_Equa.Lines.LoadFromFile(FName);    //   'Memo_Equa'  'Special.dpr'
  Form1.Memo_Equa.Lines.LoadFromFile(FName);    //   'Memo_Equa'  'Special.dpr'

    StringsGrid_Meth_Assign;    Read_Meth();
    StringsGrid_Modl_Assign;    Read_Modl();
    StringsGrid_Prob_Assign;    Read_Prob();
    //StringsGrid_Grap_Assign;
                                Read_Grap();

    GridL();    GridP();

    with Form1 do
    begin
      Memo_Tabl.Text := '';
      lQmod.Caption := '';    lIndex.Caption := '';    lStepN.Caption := '';    lInacc.Caption := '';
      StatusBar1.Panels[0].Text := ModelName;
    end;
    Form2.StatusBar2.Panels[0].Text := ModelName;

  Form2.tbb_Equa_Work.Enabled := True;
  Form2.tbb_Equa_Save.Enabled := True;
  Form2.tbb_Equa_Del.Enabled  := True;
  Form1.tbb_Calc_Run.Enabled  := True;
end;


//------------------------------------------------------------------- SetLengthMass();
procedure SetLengthMass();    // 
var
  NM1, N12, N13, NM11, N131, ND2, ND211, NM121, NB1: Integer;
begin
  N1    :=  NDIM + 1;    N12  := 2*N1;        N13  := 3*N1;       ND2   := NDIM*NDIM;
  NM1   :=  NMAX + 1;    NM11 :=  NM1 + 1;    N131 := N13 + 1;    ND211 := 2*NDIM + 1;
  NM121 := 2*NM1 + 1;    NB1  := NBIF + 1;

  SetLength (D,    NM121);
  SetLength (V,    NM11,      N1);
  SetLength (Y,    NM121,     N1);
  SetLength (A,    NM11,      2*ND2 + 1);
  SetLength (G,    N1,        N12 + 1);
  SetLength (P,    NM121,     N1);
  SetLength (F,    3*NM1 + 1, N1);
  SetLength (Q,    N131);
  SetLength (U,    N1,        N1 + 1);
  SetLength (Z,    2*N1);
  SetLength (O,    N1);
  SetLength (R,    N1);
  SetLength (X,    N1,        5);
  SetLength (T,    N1,        ND211);
  SetLength (E_,   N1,        ND211);    //E_  E
  SetLength (W,    N12,       N131);
  SetLength (YS,   N1);
  SetLength (HV,   N1);
  SetLength (HL,   N1);
  SetLength (HR,   N1);
  SetLength (B,    NMAX,      ND2 + 1);
  SetLength (HY,   N1);
  SetLength (BF1,  NB1);
  SetLength (BF2,  NB1);
  SetLength (BFX,  NB1);
  SetLength (Spar, NPAR + 1);
  SetLength (W1D,  NM11,      N1);
  //ShowMessage('SetLength');
end;


//=================================================================== StringsGrid_Meth_Assign()
procedure StringsGrid_Meth_Assign();
var
  I : Integer;
begin
  with Form1.StringGrid_Meth do
  begin
    RowCount := 33;
    for I := 1 to RowCount do    Rows[I].Clear;
    ColWidths[1] := 139;    Cells[0, 0] := 'Name';
    ColWidths[2] := 567;    Cells[1, 0] := 'Value';
                            Cells[2, 0] := 'omment';
// NDIM  NPAR   -  ,
// HTABL  (  )  --   (  ITABL),
// BON  JAC -  "" JACOB',
//  INAP  ADF.
//  -   .
    Cells[0,  1] := 'NDEL';     Cells[2,  1] := 'number of partitions of interval';
    Cells[0,  2] := 'QMOD';     Cells[2,  2] := 'start value of parameter of models';
    Cells[0,  3] := 'QSTEP';    Cells[2,  3] := 'absolute value of start step';
    Cells[0,  4] := 'DIREC';    Cells[2,  4] := 'direction of continuation on QMOD';
    Cells[0,  5] := 'IIND';     Cells[2,  5] := 'index of current parameter Y(IIND, JIND)';
    Cells[0,  6] := 'JIND';     Cells[2,  6] := 'index of current parameter Y(IIND, JIND):';
                                Cells[2,  7] := '    IIND = 1, 2, ... , NDEL+1, JIND = 1, 2, ... , NDIM,';
                                Cells[2,  8] := '    IIND = NDEL+2, JIND = 0, if QMOD is current parameter';
    Cells[0,  9] := 'IPAR';     Cells[2,  9] := 'parameter, prescribinging variants of choice of current parameter:';
                                Cells[2, 10] := '    IPAR = 0 - free-play, IPAR < NDEL - it is excluded QMOD,';
                                Cells[2, 11] := '    IPAR = NDEL+1 - parameter is QMOD, IPAR > NDEL+1,';
                                Cells[2, 12] := '    IPAR = NDEL+1 - indexes are saved on start position';
    Cells[0, 13] := 'EMIN';     Cells[2, 13] := 'lower restriction on steps on current parameters with attraction of master steps';
    Cells[0, 14] := 'ACCEL';    Cells[2, 14] := 'parameter of the runaway of the step of the current parameter';
    Cells[0, 15] := 'EMAX';     Cells[2, 15] := 'upper restriction on steps on current parameters with attraction of master steps';
    Cells[0, 16] := 'EXACT';    Cells[2, 16] := 'restriction on inaccuracy in iterations on Newton';
    Cells[0, 17] := 'LIM0';     Cells[2, 17] := 'restriction of number of iterations in method Newton in start position';
    Cells[0, 18] := 'LIM';      Cells[2, 18] := 'restriction of number of iterations in method Newton in current position';
    Cells[0, 19] := 'NCOM';     Cells[2, 19] := 'number of components, on which is adapted net';
    Cells[0, 20] := 'DMAX';     Cells[2, 20] := 'restriction on distance between nodes of net';
    Cells[0, 21] := 'NSTEP';    Cells[2, 21] := 'number of steps on parameter without adapting the net';
    Cells[0, 22] := 'EX0';      Cells[2, 22] := 'parameter, controlling direction of current parameter';
    Cells[0, 23] := 'NEND';     Cells[2, 23] := 'restriction on number of steps in method of continuation';
    Cells[0, 24] := 'HDIF';     Cells[2, 24] := 'incrementation of argument in formulas of numerical differentiation';
    Cells[0, 25] := 'EXD';      Cells[2, 25] := 'parameter, characterizing convergence iterations of Richardson';
    Cells[0, 26] := 'HMIN';     Cells[2, 26] := 'lower restriction on HDIF';
    Cells[0, 27] := 'ITABL';    Cells[2, 27] := 'step for table TABL_S';
    Cells[0, 28] := 'BON';      Cells[2, 28] := 'parameter of choice of  BOND-procedure (0 - analytical,  1 - numerical)';
    Cells[0, 29] := 'JAC';      Cells[2, 29] := 'parameter of choice of JACOB-procedure (0 - analytical,  1 - numerical)';
    Cells[0, 30] := 'INAP';     Cells[2, 30] := 'parameter of choice of initial approach:';
                                Cells[2, 31] := '    0 - numbers, 1 - tables, 2 - formulas without grid, 3 - formulas with grid';
    Cells[0, 32] := 'ADF';      Cells[2, 32] := 'parameter of call of ADFUN-procedure (0 - No, 1 - Yes)';
  end;
end;


//===================================================================  Read_Meth()
procedure Read_Meth();
var
  FileMe: String;
begin
  FileMe := ModelDir + '\Meth_Param.ish';
  if FileExists(FileMe) Then
  begin    Meth_Param_Read(FileMe);    Form1.StatusBar1.Panels[2].Text := 'Meth_Param.ish';     end
  else
  begin    Meth_Param_Read('Dflt');    Form1.StatusBar1.Panels[2].Text := 'Meth_Param_Dflt';    end;
end;

    //=================================================================== Meth_Param_Read()
    procedure Meth_Param_Read(FName : String);
    var
      tf: TextFile;    Int : Integer;    Dbl : Double;
    begin
      with Form1.StringGrid_Meth do
      begin
        if FName = 'Dflt' then    begin
                              Cells[1,  1] := '         10';
                              Cells[1,  2] := '0.00000E+00';
                              Cells[1,  3] := '2.50000E-02';
                              Cells[1,  4] := '1.00000E+00';
                              Cells[1,  5] := '         12';
                              Cells[1,  6] := '          0';
                              Cells[1,  9] := '          0';
                              Cells[1, 13] := '1.00000E-05';
                              Cells[1, 14] := '1.20000E+00';
                              Cells[1, 15] := '2.00000E+00';
                              Cells[1, 16] := '1.00000E-04';
                              Cells[1, 17] := '          7';
                              Cells[1, 18] := '          3';
                              Cells[1, 19] := '          1';
                              Cells[1, 20] := '5.00000E-02';
                              Cells[1, 21] := '          3';
                              Cells[1, 22] := '1.00000E-04';
                              Cells[1, 23] := '        800';
                              Cells[1, 24] := '1.00000E-01';
                              Cells[1, 25] := '2.00000E-01';
                              Cells[1, 26] := '1.00000E-03';
                              Cells[1, 27] := '          2';
                              Cells[1, 28] := '          0';
                              Cells[1, 29] := '          0';
                              Cells[1, 30] := '          0';
                              Cells[1, 32] := '          0';    end    //'Dflt'
        else    //Assign
        begin     AssignFile(tf, FName);    Reset(tf);
          readln(tf, Int);    Cells[1,  1] := Format('%11d', [Int]);                 //ShowMessage('NDEL     = ' + Cells[1,  1]);
          readln(tf, Dbl);    Cells[1,  2] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('QMOD     = ' + Cells[1,  2]);
          readln(tf, Dbl);    Cells[1,  3] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('QSTEP    = ' + Cells[1,  3]);
          readln(tf, Dbl);    Cells[1,  4] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('DIREC    = ' + Cells[1,  4]);
          readln(tf, Int);    Cells[1,  5] := Format('%11d', [Int]);                 //ShowMessage('IIND     = ' + Cells[1,  5]);
          readln(tf, Int);    Cells[1,  6] := Format('%11d', [Int]);                 //ShowMessage('JIND     = ' + Cells[1,  6]);
          readln(tf);
          readln(tf);
          readln(tf, Int);    Cells[1,  9] := Format('%11d', [Int]);                 //ShowMessage('IPAR     = ' + Cells[1,  9]);
          readln(tf);
          readln(tf);
          readln(tf);
          readln(tf, Dbl);    Cells[1, 13] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('EMIN     = ' + Cells[1, 13]);
          readln(tf, Dbl);    Cells[1, 14] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('ACCEL    = ' + Cells[1, 14]);
          readln(tf, Dbl);    Cells[1, 15] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('EMAX     = ' + Cells[1, 15]);
          readln(tf, Dbl);    Cells[1, 16] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('EXACT    = ' + Cells[1, 16]);
          readln(tf, Int);    Cells[1, 17] := Format('%11d', [Int]);                 //ShowMessage('LIM0     = ' + Cells[1, 17]);
          readln(tf, Int);    Cells[1, 18] := Format('%11d', [Int]);                 //ShowMessage('LIM      = ' + Cells[1, 18]);
          readln(tf, Int);    Cells[1, 19] := Format('%11d', [Int]);                 //ShowMessage('NCOM     = ' + Cells[1, 19]);
          readln(tf, Dbl);    Cells[1, 20] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('DMAX     = ' + Cells[1, 20]);
          readln(tf, Int);    Cells[1, 21] := Format('%11d', [Int]);                 //ShowMessage('NSTEP    = ' + Cells[1, 21]);
          readln(tf, Dbl);    Cells[1, 22] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('EX0      = ' + Cells[1, 22]);
          readln(tf, Int);    Cells[1, 23] := Format('%11d', [Int]);                 //ShowMessage('NEND     = ' + Cells[1, 23]);
          readln(tf, Dbl);    Cells[1, 24] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('HDIF     = ' + Cells[1, 24]);
          readln(tf, Dbl);    Cells[1, 25] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('EXD      = ' + Cells[1, 25]);
          readln(tf, Dbl);    Cells[1, 26] := FloatToStrF(Dbl, ffexponent, 6, 2);    //ShowMessage('HMIN     = ' + Cells[1, 26]);
          readln(tf, Int);    Cells[1, 27] := Format('%11d', [Int]);                 //ShowMessage('ITABL    = ' + Cells[1, 27]);
          readln(tf, Int);    Cells[1, 28] := Format('%11d', [Int]);                 //ShowMessage('BON      = ' + Cells[1, 28]);
          readln(tf, Int);    Cells[1, 29] := Format('%11d', [Int]);                 //ShowMessage('JAC      = ' + Cells[1, 29]);
          readln(tf, Int);    Cells[1, 30] := Format('%11d', [Int]);                 //ShowMessage('INAP     = ' + Cells[1, 30]);
          readln(tf, Int);    Cells[1, 32] := Format('%11d', [Int]);                 //ShowMessage('ADF      = ' + Cells[1, 32]);
          CloseFile(tf);
        end;    //else Assign
      end;    //with Form1
    end;


//=================================================================== StringsGrid_Modl_Assign()
procedure StringsGrid_Modl_Assign();
var
  I : Integer;
begin
  Par_Nam_Save();

  with Form1.StringGrid_Modl do
  begin
    RowCount := (NPAR + 1);
    for I := 1 to RowCount do    Rows[I].Clear;
    ColWidths[1] := 140;            Cells[0, 0]                := 'Name';
    ColWidths[2] := 550;            Cells[1, 0]                := 'Value';
                                    Cells[2, 0]                := 'omment';
    for I := 1 to NPAR do           Cells[0, I]                := Par_Name[I];
                                    {Cells[2, NPAR+1]           := 'Intervals Boundarys';
                                    Cells[0, NPAR+2]           := 'XMIN';
                                    Cells[0, NPAR+3]           := 'XMAX';
                                    Cells[0, NPAR+4]           := 'QMIN';
                                    Cells[0, NPAR+5]           := 'QMAX';
                                    Cells[0, NPAR+6]           := 'QSOLV';}
  end;
end;

//===================================================================  Read_Modl()
procedure Read_Modl();
var
  FileMo: String;
begin
  FileMo := ModelDir + '\Modl_Param.ish';
  if FileExists(FileMo) Then
  begin    Modl_Param_Read(FileMo);    Form1.StatusBar1.Panels[3].Text := 'Modl_Param.ish';     end
  else
  begin    Modl_Param_Read('Dflt');    Form1.StatusBar1.Panels[3].Text := 'Modl_Param_Dflt';    end;
end;

    //=================================================================== Prob_Param_Read()
    procedure Modl_Param_Read(FName : String);
    var
      tf : TextFile;    I : Integer;    Dbl : Double;
    begin
      with Form1.StringGrid_Modl do
      begin
        if FName = 'Dflt' then
        //begin
          for I := 1 to NPAR do
          //begin
            Cells[1,      I] := '1.00000E+00'    //;    //end;
          //end    //'Dflt'
        else    //Assign
        begin     AssignFile(tf, FName);    Reset(tf);
          for I := 1 to NPAR do
          begin
            read(tf, Dbl);           Cells[1,      I] := FloatToStrF(Dbl,   ffexponent, 6, 2);       end;
          CloseFile(tf);
        end;    //else Assign
      end;    //with Form1
    end;


//=================================================================== StringsGrid_Prob_Assign()
procedure StringsGrid_Prob_Assign();
var
  J : Integer;
begin
  with Form1.StringGrid_Prob do
  begin
    RowCount := NDIM + 3;
    for J := 1 to RowCount do    Rows[J].Clear;
    for J := 1 to 5 do           ColWidths[J] := 137;    ColWidths[3] := 139;
                                 Cells[0, 1]  := 'J';
                                 Cells[1, 0]  := 'Standart Steps';
                                 Cells[1, 1]  := 'HV[J] & HMOD';
                                 Cells[2, 0]  := 'Scales';
                                 Cells[2, 1]  := 'YS[J] & QMODS';
                                 Cells[3, 0]  := 'Left Restrictions';
                                 Cells[3, 1]  := 'HL[J]';
                                 Cells[4, 0]  := 'Right Restrictions';
                                 Cells[4, 1]  := 'HR[J]';
                                 Cells[5, 0]  := 'Initial Approach';
                                 Cells[5, 1]  := 'HY[J]';
    for J := 2 to NDIM + 2 do    Cells[0, J]  := IntToStr(J - 1);
  end;
end;


//===================================================================  Read_Prob()
procedure Read_Prob();
var
  FileP: String;
begin
  FileP := ModelDir + '\Prob_Param.ish';
  if FileExists(FileP) Then
  begin    Prob_Param_Read(FileP);     Form1.StatusBar1.Panels[4].Text := 'Prob_Param.ish';     end
  else
  begin    Prob_Param_Read('Dflt');    Form1.StatusBar1.Panels[4].Text := 'Prob_Param_Dflt';    end;
end;

    //=================================================================== Prob_Param_Read()
    procedure Prob_Param_Read(FName : String);
    var
      tf : TextFile;    I : Integer;    Dbl : Double;
    begin
      with Form1.StringGrid_Prob do
      begin
        if FName = 'Dflt' then
        begin
          for I := 1 to NDIM do    begin    Cells[1, 1 + I]    :=  '1.00000E-01';    end;
                                            Cells[1, NDIM + 2] :=  '1.00000E-02';
          for I := 1 to NDIM do    begin    Cells[2, 1 + I]    :=  '1.00000E+00';    end;
                                            Cells[2, NDIM + 2] :=  '1.00000E+00';
          for I := 1 to NDIM do    begin    Cells[3, 1 + I]    := '-1.00000E+06';    end;
          for I := 1 to NDIM do    begin    Cells[4, 1 + I]    :=  '1.00000E+06';    end;
          for I := 1 to NDIM do    begin    Cells[5, 1 + I]    :=  '0.00000E+00';    end;    end    //'Dflt'
        else    //Assign
        begin     AssignFile(tf, FName);    Reset(tf);
          for I := 1 to NDIM do    begin
                  readln(tf, Dbl);   Cells[1, 1 + I]    := FloatToStrF(Dbl, ffexponent, 6, 2);    end;
                readln(tf, Dbl);     Cells[1, NDIM + 2] := FloatToStrF(Dbl, ffexponent, 6, 2);            readln(tf);
          for I := 1 to NDIM do   begin
                  readln(tf, Dbl);   Cells[2, 1 + I]    := FloatToStrF(Dbl, ffexponent, 6, 2);    end;
                readln(tf, Dbl);     Cells[2, NDIM + 2] := FloatToStrF(Dbl, ffexponent, 6, 2);            readln(tf);
          for I := 1 to NDIM do   begin
                  readln(tf, Dbl);   Cells[3, 1 + I]    := FloatToStrF(Dbl, ffexponent, 6, 2);    end;    readln(tf);
          for I := 1 to NDIM do   begin
                  readln(tf, Dbl);   Cells[4, 1 + I]    := FloatToStrF(Dbl, ffexponent, 6, 2);    end;    readln(tf);
          for I := 1 to NDIM do   begin
                  readln(tf, Dbl);   Cells[5, 1 + I]    := FloatToStrF(Dbl, ffexponent, 6, 2);    end;
          CloseFile(tf);
        end;    //else Assign
      end;    //with Form1
    end;


//===================================================================  Read_Grap()
procedure Read_Grap();
var
  FileG: String;
begin
  FileG := ModelDir + '\Grap_Param.ish';
  if FileExists(FileG) Then
  begin    Grap_Param_Read(FileG);     Form1.StatusBar1.Panels[5].Text := 'Grap_Param.ish';     end
  else
  begin    Grap_Param_Read('Dflt');    Form1.StatusBar1.Panels[5].Text := 'Grap_Param_Dflt';    end;
end;

    //=================================================================== Grap_Param_Read()
    // ---  2   ---
    procedure Grap_Param_Read(FName : String);
    //               ( . - .)
    var
      tf3 : TextFile;    PI : Integer;    PF : Double;
    begin
      with Form1 do
      begin
        if FName = 'Dflt' then
        begin                        eXMin.Text   := '0.00000E+00';
                                     eXMax.Text   := '1.00000E+00';
                                     eQMin.Text   := '0.00000E+00';
                                     eQMax.Text   := '1.00000E+00';
                                     eQSolv.Text  := '5.00000E-01';
                                     NuCo_L1.Text := '     1';    // -  
                                     eMin_L1.Text := '0.00000E+00';
                                     eMax_L1.Text := '1.00000E+00';
                                     NuCo_L2.Text := '     2';
                                     eMin_L2.Text := '0.00000E+00';
                                     eMax_L2.Text := '1.00000E+00';
                                     NuCo_L3.Text := '     3';
                                     eMin_L3.Text := '0.00000E+00';
                                     eMax_L3.Text := '1.00000E+00';
                                     NuCo_L4.Text := '     0';
                                     eMin_L4.Text := '0.00000E+00';
                                     eMax_L4.Text := '0.00000E+00';
                                     NuCo_L5.Text := '     0';
                                     eMin_L5.Text := '0.00000E+00';
                                     eMax_L5.Text := '0.00000E+00';
                                     NuCo_P1.Text := '     1';    // -  
                                     eMin_P1.Text := '0.00000E+00';
                                     eMax_P1.Text := '1.00000E+00';
                                     NuCo_P2.Text := '     2';
                                     eMin_P2.Text := '0.00000E+00';
                                     eMax_P2.Text := '1.00000E+00';    end    //'Dflt'
        else    //Assign
        begin
          AssignFile(tf3, FName);    Reset(tf3);
          readln(tf3, PF);           eXMin.Text   := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3, PF);           eXMax.Text   := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3, PF);           eQMin.Text   := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3, PF);           eQMax.Text   := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3, PF);           eQSolv.Text  := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3);
          readln(tf3, PI);           NuCo_L1.Text := Format('%6d', [PI]);    // -  
          readln(tf3, PF);           eMin_L1.Text := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3, PF);           eMax_L1.Text := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3, PI);           NuCo_L2.Text := Format('%6d', [PI]);
          if PI = 0 then
          begin    readln(tf3);      eMin_L2.Text := '0.00000E+00';
                   readln(tf3);      eMax_L2.Text := '0.00000E+00';    end
          else
          begin    readln(tf3, PF);  eMin_L2.Text := FloatToStrF(PF, ffexponent, 6, 2);
                   readln(tf3, PF);  eMax_L2.Text := FloatToStrF(PF, ffexponent, 6, 2);    end;
          readln(tf3, PI);           NuCo_L3.Text := Format('%6d', [PI]);
          if PI = 0 then
          begin    readln(tf3);      eMin_L3.Text := '0.00000E+00';
                   readln(tf3);      eMax_L3.Text := '0.00000E+00';    end
          else
          begin    readln(tf3, PF);  eMin_L3.Text := FloatToStrF(PF, ffexponent, 6, 2);
                   readln(tf3, PF);  eMax_L3.Text := FloatToStrF(PF, ffexponent, 6, 2);    end;
          readln(tf3);
          readln(tf3, PI);           NuCo_L4.Text := Format('%6d', [PI]);
          if PI = 0 then
          begin    readln(tf3);      eMin_L4.Text := '0.00000E+00';
                   readln(tf3);      eMax_L4.Text := '0.00000E+00';    end
          else
          begin    readln(tf3, PF);  eMin_L4.Text := FloatToStrF(PF, ffexponent, 6, 2);
                   readln(tf3, PF);  eMax_L4.Text := FloatToStrF(PF, ffexponent, 6, 2);    end;
          readln(tf3, PI);           NuCo_L5.Text := Format('%6d', [PI]);
          if PI = 0 then
          begin    readln(tf3);      eMin_L5.Text := '0.00000E+00';
                   readln(tf3);      eMax_L5.Text := '0.00000E+00';    end
          else
          begin    readln(tf3, PF);  eMin_L5.Text := FloatToStrF(PF, ffexponent, 6, 2);
                   readln(tf3, PF);  eMax_L5.Text := FloatToStrF(PF, ffexponent, 6, 2);    end;
          readln(tf3);
          readln(tf3, PI);           NuCo_P1.Text := Format('%6d', [PI]);    // -  
          readln(tf3, PF);           eMin_P1.Text := FloatToStrF(PF, ffexponent, 6, 2);
          readln(tf3, PF);           eMax_P1.Text := FloatToStrF(PF, ffexponent, 6, 2);

          readln(tf3, PI);           NuCo_P2.Text := Format('%6d', [PI]);
          if PI = 0 then
          begin    readln(tf3);      eMin_P2.Text := '0.00000E+00';
                   readln(tf3);      eMax_P2.Text := '0.00000E+00';    end
          else
          begin    readln(tf3, PF);  eMin_P2.Text := FloatToStrF(PF, ffexponent, 6, 2);
                   readln(tf3, PF);  eMax_P2.Text := FloatToStrF(PF, ffexponent, 6, 2);    end;
          CloseFile(tf3);
        end;    //else Assign
      end;    //with Form1
    end;


//=================================================================== GridL()
procedure GridL();
begin
  with BitMapL.Canvas do
  begin
    Pen.Style := psSolid;      Brush.Color := $00F0FFFF;
    Pen.Color := $00000000;    Brush.Style := bsSolid;
    Pen.Width := 1;            Rectangle(0, 0, Wid_Lev, Hei_Lev);

    Pen.Style := psDot;    Pen.Color := $00AAAAAA;
    MoveTo(0, Ser_Ver);    LineTo(Wid_Lev, Ser_Ver);
    MoveTo(Ser_Hor, 0);    LineTo(Ser_Hor, Hei_Lev);
  end;
  Form1.PaintBox1.Canvas.Draw(0,0,BitMapL);
end;

//=================================================================== GridP()
procedure GridP();
begin
  with BitMapP.Canvas do
  begin
    Pen.Style := psSolid;      Brush.Color := $00F0FFFF;
    Pen.Color := $00000000;    Brush.Style := bsSolid;
    Pen.Width := 1;            Rectangle(0, 0, Wid_Lev, Hei_Lev);

    Pen.Style := psDot;    Pen.Color := $00AAAAAA;
    MoveTo(0, Ser_Ver);    LineTo(Wid_Lev, Ser_Ver);
    MoveTo(Ser_Hor, 0);    LineTo(Ser_Hor, Hei_Lev);
  end;
  Form1.PaintBox2.Canvas.Draw(0,0,BitMapP);
end;


//=================================================================== Assign_File()
procedure Assign_File();    //   
var
  Str1, Str2 : String;
begin
  //ShowMessage('Assign_File_begin');
  //ShowMessage('Assign_ModelDir = ' + ModelDir);
  Str1 := ' --- ' + DateToStr(Date) + ' --- ' + TimeToStr(Time) + ' --- ';
  Str2 := ' --- ' + ModelName + ' --- ';
  AssignFile(fTABL_Sol, ModelDir + '\fTABL_Sol.rsl');
  //{$I-}
              //ShowMessage('IOResult = ' + IntToStr(IOResult));
  Rewrite(fTABL_Sol);
     writeln(fTABL_Sol, Str1);    writeln(fTABL_Sol, '');    writeln(fTABL_Sol, Str2);    writeln(fTABL_Sol, '');
     writeln(fTABL_Sol, '  Solution dependency from parameter Q');

  AssignFile(fTABL_Qsl, ModelDir + '\fTABL_Qsl.rsl');        Rewrite(fTABL_Qsl);
     writeln(fTABL_Qsl, Str1);    writeln(fTABL_Qsl, '');    writeln(fTABL_Qsl, Str2);    writeln(fTABL_Qsl, '');
     writeln(fTABL_Qsl, '  Solution under given value of parameter Q');

  AssignFile(fTABL_Bif, ModelDir + '\fTABL_Bif.rsl');        Rewrite(fTABL_Bif);
     writeln(fTABL_Bif, Str1);    writeln(fTABL_Bif, '');    writeln(fTABL_Bif, Str2);    writeln(fTABL_Bif, '');
     writeln(fTABL_Bif, '  Solution in switchpoint on parameter Q');

  AssignFile(fTABL_Mul, ModelDir + '\fTABL_Mul.rsl');        Rewrite(fTABL_Mul);
     writeln(fTABL_Mul, Str1);    writeln(fTABL_Mul, '');    writeln(fTABL_Mul, Str2);    writeln(fTABL_Mul, '');
     writeln(fTABL_Mul, '  Presentation to multiplicity of solutions');                   writeln(fTABL_Mul, '');
     writeln(fTABL_Mul, '     i       Q           BF1          BF2');
     writeln(fTABL_Mul, '  +----+------------+------------+------------+');
  //{$I+}
  //ShowMessage('Assign_File_end');
end;


//=================================================================== Template_()
procedure TEMPLATE_();
//          
var
  I : Integer;    Str1 : String;
begin
  with Form2.Memo_Equa.Lines do
  begin
    Clear;
    Add('//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++');
    Add('//                                                                              ');
    Add('//        MODEL of ...');
    Add('//                                                                              ');
    Add('//              Wording of the boundary problem');
    Add('//');
    Add('//    System of the equations:');
    Add('//');
    Add('//    Boundary conditions:');
    Add('//');
    Add('//         ' + Par_Name[1] + ' - parameter of the continuation');
    Add('//');
    Add('//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++');
    Add('');

    Add('library Special;');
    Add('');
    Add('uses Math;');
    Add('');
    Add('type');
    Add('  TD = array of Double;');
    Add('  TV = array of array of Double;');
    Add('  TArr3I = array [0..3] of Integer;');
    Add('');
    Add('const');
    Add('  PI = 3.14159265358979;');
    Add('');
    Add('var');
    Str1 := '  ';
    for I := 1 to NPAR - 1 do
    begin
      Str1 := Str1 + Par_Name[I] + ', ';
      if (I MOD 10 = 0) then
        Str1 := Str1 + #13#10 + '  ';
    end;
    Str1 := Str1 + Par_Name[NPAR] + #13#10 + '  : Double;';
    Add(Str1);
    Add('');
    Add('');

    Add('//============================================================================= RENAM');
    Add('procedure RENAM(SPar: TD);   Export;');
    Add('begin');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Str1 := '';
    for I := 1 to NPAR - 1 do
      Str1 := Str1 + '  ' + Par_Name[I] + ' := SPar[' + IntToStr(I) + '];' + #13#10;
    Str1 := Str1 + '  ' + Par_Name[NPAR] + ' := SPar[' + IntToStr(NPAR) + '];';
    Add(Str1);
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('end;');
    Add('');
    Add('');

    Add('//============================================================================= BOND');
    Add('procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;');
    Add('var');
    Add('  I, J: Integer;');
    Add('begin');
    Add('  for I := 1 to NDIM do');
    Add('    for J := 1 to N2 + 1 do');
    Add('      G[I, J] := 0.;');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('end;');
    Add('');
    Add('');

    Add('//============================================================================= LISTB');
    Add('procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;');
    Add('//----------------------------------------------------------------- Spec_begin');
    Add('//----------------------------------------------------------------- Spec_end');
    Add('begin');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  case LN_ of');
    for I := 1 to NDIM do
      Add('    ' + IntToStr(I) + ':   GG := 0;');
    Add('  end;');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('end;');
    Add('');
    Add('');

    Add('//============================================================================= JACOB');
    Add('procedure JACOB(NDIM: Integer;   DD, QMOD: Double;   Q: TD;');
    Add('                var O,R: TD;   var U: TV);   Export;');
    Add('var');
    Add('  I, J: Integer;');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('begin');
    Add('  for I := 1 to NDIM do');
    Add('  begin');
    Add('    for J := 1 to NDIM + 1 do');
    Add('      U[I, J] := 0.;');
    Add('    R[I] := 0.;');
    Add('  end;   //   I');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  ' + Par_Name[1] + ' := QMOD;');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('end;');
    Add('');
    Add('');

    Add('//============================================================================= LISTJ');
    Add('procedure LISTJ(LN_: Integer;   DD, QMOD: Double;   Z: TD;   var FF: Double);   Export;');
    Add('//----------------------------------------------------------------- Spec_begin');
    Add('//----------------------------------------------------------------- Spec_end');
    Add('begin');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  Case LN_ Of');
    for I := 1 to NDIM do
      Add('    ' + IntToStr(I) + ':   FF := 0;');
    Add('  end;');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('end;');
    Add('');
    Add('');

    Add('//============================================================================= BIFC');
    Add('procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;');
    Add('               var BFX, BF1, BF2: TD);   Export;');
    Add('//----------------------------------------------------------------- Spec_begin');
    Add('//----------------------------------------------------------------- Spec_end');
    Add('begin');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  BFX[ISTEP + 1] := QMOD;');
    Add('  BF1[ISTEP + 1] := 0;');
    Add('  BF2[ISTEP + 1] := 0;');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('end;');
    Add('');
    Add('');

    Add('//============================================================================= INAPP');
    Add('procedure INAPP(N5, NDIM, INAP: Integer;   var D : TD;   var V: TV);   Export;');
    Add('var');
    Add('  I : Integer;');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('begin');
    Add('    if INAP = 3 then     //Non-standard setting of a grid D[I]:');
    Add('    begin');
    Add('      //----------------------------------------------------------- Spec_begin');
    Add('      D[1]  := 0;');
    Add('      // ...');
    Add('      D[N5] := 1;');
    Add('      //----------------------------------------------------------- Spec_end');
    Add('    end;');
    Add('');
    Add('  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:');
    Add('  begin');
    Add('    //------------------------------------------------------------- Spec_begin');
    Add('    V[I, 1]    := 0;');
    Add('    // ...');
    Add('    V[I, NDIM] := 0;');
    Add('    //------------------------------------------------------------- Spec_end');
    Add('  end;');
    Add('end;');
    Add('');
    Add('');

    Add('//============================================================================= ADFUN');
    Add('procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;');
    Add('var');
    Add('  I: Integer;');
    Add('  //--------------------------------------------------------------- Spec_begin');
    Add('  //--------------------------------------------------------------- Spec_end');
    Add('begin');
    Add('  for I := 1 to N5 do');
    Add('  begin');
    Add('    //------------------------------------------------------------- Spec_begin');
    Add('    WD[I, 1] := 2 * V[I, 1];');
    Add('    //------------------------------------------------------------- Spec_end');
    Add('  end;');
    Add('end;');
    Add('');
    Add('');

    Add('Exports');
    Add('  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;');
    Add('');
    Add('');

    Add('begin');
    Add('end.');

    //Form1.tbb_Equa_Save.Enabled := True;
  end;
end;


//=================================================================== Par_Nam_Save()
procedure Par_Nam_Save();
var
  I, J, K : Integer;    StrM : String;
begin
  SetLength(Par_Name, NPAR + 1);         I := 0;
  repeat
    StrM := Form2.Memo_Equa.Lines[I];    I := I + 1;
  until StrM = 'var';                    I := I - 1;    J := 0;
  if NPAR_div > 0 then
    for J := 1 to NPAR_div do
    begin
      StrM := Form2.Memo_Equa.Lines[I + J];    StrArr := fcToParts(StrM, [',']);
      for K := 0 to 9 do
        Par_Name[(J - 1)*10 + (K + 1)] := Trim(StrArr[K]);
    end;
  if (NPAR_mod > 0) then
  begin
    StrM := Form2.Memo_Equa.Lines[I + NPAR_div + 1];    StrArr := fcToParts(StrM, [',']);
    for K := 0 to NPAR_mod - 1  do
      if J > 0 then    Par_Name[(J - 1)*10 + (K + 1)]   := Trim(StrArr[K])
      else             Par_Name[             (K + 1)]   := Trim(StrArr[K]);
  end;
end;


end.
