//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                                                              
//                    --
//
//      : 0<=t<=1,
// 
//          dy1/dt = y3 * y2,
//          dy2/dt = y3 * [-y1 + Q * y2 * (1 - y1^2)],
//          dy3/dt  = 0,
//
//      
//     
//          y3 -  , 
//          Q  -    .
//     
//      :
//
//     a)  :  y1(0) = y1(1), y2(0) = y2(1),
//    
//     )   : y2(0) = 0.
// 
//          
//         Q. 
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

library Special;

uses Math;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;

//const
//  PI - 3.14159265;

var
  DPI
  : Double;


//============================================================================= RENAM
procedure RENAM(SPar: TD);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  DPI := SPar[1];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BOND
procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;
var
  K, J: Integer;
begin
  for K := 1 to NDIM do
    for J := 1 to N2 + 1 do
      G[K, J] := 0.;
  //--------------------------------------------------------------- Spec_begin
  for K:= 1 to NDIM-1 do
  begin
    G[K,K] := 1.;
    G[K,K+NDIM] := -1.;
    G[K,N2+2] := V[1,K] - V[N5,K];
  end;
  G[3,2] := 1.;
  G[3,N2+2] := V[1, 2];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTB
procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;
//----------------------------------------------------------------- Spec_begin
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  case LN_ of
    1:   GG := 0;
    2:   GG := 0;
    3:   GG := 0;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= JACOB
procedure JACOB(NDIM: Integer;   DD, QMOD: Double;   Q: TD;
                var O,R: TD;   var U: TV);   Export;
var
  I, J: Integer;
  //--------------------------------------------------------------- Spec_begin
  ZZ: Double;
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to NDIM do
  begin
    for J := 1 to NDIM + 1 do
      U[I, J] := 0.;
    R[I] := 0.;
  end;   //   I
  //--------------------------------------------------------------- Spec_begin
  DPI := QMOD;
  O[1] := Q[3] * Q[2];
   U[1,2] := Q[3];
   U[1,3] := Q[2];
   ZZ := (1. - Q[1]) * (1. + Q[1]);
   U[2,3] := -Q[1] + DPI * Q[2] * ZZ;
  O[2] := Q[3] * U[2,3];
  R[2] := Q[3] * Q[2] * ZZ;
   U[2,1] := -Q[3] * (1. + 2. * DPI * Q[1] * Q[2]);
   U[2,2] :=  Q[3] * DPI * ZZ;
  O[3] := 0;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTJ
procedure LISTJ(LN_: Integer;   DD, QMOD: Double;   Z: TD;   var FF: Double);   Export;
//----------------------------------------------------------------- Spec_begin
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  Case LN_ Of
    1:   FF := 0;
    2:   FF := 0;
    3:   FF := 0;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BIFC
procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;
               var BFX, BF1, BF2: TD);   Export;
//----------------------------------------------------------------- Spec_begin
var
  I: Integer;    CMIN, CMAX: Double;
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  IF ISTEP = 0 THEN
    begin
      BFX[1] := 0.01;    BF1[1] := 4;    BF2[1] := 6.2832;
    end
  ELSE
    begin
      BFX[ISTEP + 1] := QMOD;    CMIN := 1E+10;    CMAX := -1E+10;
      FOR I := 1 TO N5 DO
      begin
        IF V[I, 1] > CMAX THEN CMAX := V[I, 1];
        IF V[I, 1] < CMIN THEN CMIN := V[I, 1];
      end;
      BF1[ISTEP + 1] := CMAX - CMIN;
      BF2[ISTEP + 1] := V[N5, 3];
    end;

  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= INAPP
procedure INAPP(N5, NDIM, INAP: Integer;   var D : TD;   var V: TV);   Export;
var
  I : Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  if INAP = 3 then     //Non-standard setting of a grid D[I]:
  begin
    //------------------------------------------------------------- Spec_begin
    D[1]  := 0;
    // ...
    D[N5] := 1;
    //------------------------------------------------------------- Spec_end
  end;

  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:
  begin
    //------------------------------------------------------------- Spec_begin
    V[I, 1]    :=  2.    *cos(DPI*D[I]);
    V[I, 2]    := -2.*DPI*sin(DPI*D[I]);
    V[I, NDIM] := DPI;
    //------------------------------------------------------------- Spec_end
  end;
end;


//============================================================================= ADFUN
procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;
var
  I: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to N5 do
  begin
    //------------------------------------------------------------- Spec_begin
    WD[I, 1] := 2 * V[I, 1];
    //------------------------------------------------------------- Spec_end
  end;
end;


Exports
  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;


begin
end.
