//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                                                              
//        MODEL of ...
//                                                                              
//              Wording of the boundary problem
//
//    System of the equations:
//
//    Boundary conditions:
//
//         SP1 - parameter of the continuation
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

library Special;

uses Math;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;

const
  PI = 3.14159265358979;

var
  SP1, SP2, SP3, SP4, SP5, SP6, SP7
  : Double;


//============================================================================= RENAM
procedure RENAM(SPar: TD);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  SP1 := SPar[1];
  SP2 := SPar[2];
  SP3 := SPar[3];
  SP4 := SPar[4];
  SP5 := SPar[5];
  SP6 := SPar[6];
  SP7 := SPar[7];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BOND
procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;
var
  I, J: Integer;
begin
  for I := 1 to NDIM do
    for J := 1 to N2 + 1 do
      G[I, J] := 0.;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTB
procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;
//----------------------------------------------------------------- Spec_begin
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  case LN_ of
    1:   GG := 0;
    2:   GG := 0;
    3:   GG := 0;
    4:   GG := 0;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= JACOB
procedure JACOB(NDIM: Integer;   DD, QMOD: Double;   Q: TD;
                var O,R: TD;   var U: TV);   Export;
var
  I, J: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to NDIM do
  begin
    for J := 1 to NDIM + 1 do
      U[I, J] := 0.;
    R[I] := 0.;
  end;   //   I
  //--------------------------------------------------------------- Spec_begin
  SP1 := QMOD;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTJ
procedure LISTJ(LN_: Integer;   DD, QMOD: Double;   Z: TD;   var FF: Double);   Export;
//----------------------------------------------------------------- Spec_begin
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  Case LN_ Of
    1:   FF := 0;
    2:   FF := 0;
    3:   FF := 0;
    4:   FF := 0;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BIFC
procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;
               var BFX, BF1, BF2: TD);   Export;
//----------------------------------------------------------------- Spec_begin
//----------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  BFX[ISTEP + 1] := QMOD;
  BF1[ISTEP + 1] := 0;
  BF2[ISTEP + 1] := 0;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= INAPP
procedure INAPP(N5, NDIM, INAP: Integer;   var D : TD;   var V: TV);   Export;
var
  I : Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
    if INAP = 3 then     //Non-standard setting of a grid D[I]:
    begin
      //----------------------------------------------------------- Spec_begin
      D[1]  := 0;
      // ...
      D[N5] := 1;
      //----------------------------------------------------------- Spec_end
    end;

  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:
  begin
    //------------------------------------------------------------- Spec_begin
    V[I, 1]    := 0;
    // ...
    V[I, NDIM] := 0;
    //------------------------------------------------------------- Spec_end
  end;
end;


//============================================================================= ADFUN
procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;
var
  I: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to N5 do
  begin
    //------------------------------------------------------------- Spec_begin
    WD[I, 1] := 2 * V[I, 1];
    //------------------------------------------------------------- Spec_end
  end;
end;


Exports
  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;


begin
end.
