//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                                                              
//                                           
//                    
//                    
//                   
//          
//     (.,.,.,..  
//       .-.:, 1991.- 368 . 
//     (.  16.       
//         ))          
//     -----------------------------------------------------
//
//      : 0<=t<=1,
//
//          dy1/dt = y3,
//          dy2/dt = y4,
//          dy3/dt = -(SYM / t) * y3 + Q * RZ^2 * W(y1,y2),
//          dy4/dt = -(SYM / t) * y3 - Q * RZ^2 * BETA * W(y1,y2),
//
//      
//
//          W(y1,y2) =  y1^DEGR * exp(GAMA * (1 - 1 / y2)),
//          Q -    .
//
//      :
//
//          t = 0:   y3 = 0,   y4 = 0,
//          t = 1:   y3 = RZ * BI1 * (Y01 - y1),
//                   y4 = RZ * BI2 * (Y02 - y2)
//
//      :
//
//          Y01, Y02, BI1, BI2, SYM, BETA, GAMA, DEGR, RZ.
//
//          
//       Q  y2(0)     
//       FACTOR:
//      
//          FACTOR = (SYM + 1) * y3 / W(y1,y2) / RZ^2 / Q,
//
//           t = 1. 
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

library Special;

uses Math;

type
  TD = array of Double;
  TV = array of array of Double;
  TArr3I = array [0..3] of Integer;
  //--------------------------------------------------------------- Spec_begin
var
  Y01, Y02, BI1, BI2, SYM, BETA, GAMA, DEGR, RZ
  : Double;
  //--------------------------------------------------------------- Spec_end


//============================================================================= RENAM
procedure RENAM(SPar: TD);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  Y01 := SPar[1];
  Y02 := SPar[2];
  BI1 := SPar[3];
  BI2 := SPar[4];
  SYM := SPar[5];
  BETA := SPar[6];
  GAMA := SPar[7];
  DEGR := SPar[8];
  RZ := SPar[9];
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BOND
procedure BOND(NDIM, N2, N5: Integer;   V: TV;   var G: TV);   Export;
var
 K, J: Integer;
begin
  for K := 1 to NDIM do
    for J := 1 to N2 + 1 do
      G[K, J] := 0.;
  //--------------------------------------------------------------- Spec_begin
  G[1,N2+2]       := V[1,1+2];    
  G[2,N2+2]       := V[1,2+2];
  G[3,N2+2]     := V[N5,3]-RZ*BI1*(Y01-V[N5,1]);
  G[4,N2+2]     := V[N5,4]-RZ*BI2*(Y02-V[N5,2]);
  G[1,3]        := 1.;
  G[2,4]        := 1.;
  G[3,1+NDIM]   := RZ*BI1;
  G[4,2+NDIM]   := RZ*BI2;
  G[3,3+NDIM] := 1.;
  G[4,4+NDIM] := 1.;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTB
procedure LISTB(LN_: Integer;   Z: TD;   var GG: Double);   Export;
begin
  //--------------------------------------------------------------- Spec_begin
  case LN_ of
    1:   GG := 0;
    2:   GG := 0;
    3:   GG := 0;
    4:   GG := 0;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= JACOB
procedure JACOB(NDIM: Integer;   D, QMOD: Double;   Q: TD;
                var O,R: TD;   var U: TV);   Export;
var
  K, J: Integer;
  //--------------------------------------------------------------- Spec_begin
  EE,WW,W1,W2: Double;
  //--------------------------------------------------------------- Spec_end
begin
  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM + 1 do
      U[K, J] := 0.;
    R[K] := 0.;
  end;   //   I
  //--------------------------------------------------------------- Spec_begin
  for K := 1 to 2 do
  begin
    O[K] := Q[K+2];
    U[K,K+2] := 1E0;
  end;
  EE := EXP(GAMA * (1E0 - 1E0 / Q[2]));
  WW := Power(Q[1],DEGR) * EE;
  W1 := DEGR * Power(Q[1],DEGR-1E0) * EE;
  W2 := GAMA * WW / (Q[2] * Q[2]);
  O[3] := QMOD * WW;
  U[3, 1] := QMOD * W1;
  U[3, 2] := QMOD * W2;
  R[3] := WW;
  O[4] := -BETA * O[3];
  U[4, 1] := -BETA * U[3, 1];
  U[4, 2] := -BETA * U[3, 2];
  R[4] := -BETA * R[3];
  if ABS(D) < 1E-5 then
    for K := 1 to 2 do
    begin
      for J := 1 to 2 do
        U[K+2,J] := U[K+2,J] / (SYM+1E0);
      O[K+2] := O[K+2] / (SYM+1E0);
      R[K+2] := R[K+2] / (SYM+1E0);
    end
  else
  for K := 1 to 2 do
  begin
    O[K+2] := O[K+2] - SYM * Q[K+2] / D;
    U[K+2,K+2] := -SYM / D;
    U[K+2,NDIM+1] := SYM * Q[K+2] / (D * D);
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= LISTJ
procedure LISTJ(LN_: Integer;   D: Double;   Z: TD;   var FF: Double);   Export;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  Case LN_ Of
    1:   FF := 0;
    2:   FF := 0;
    3:   FF := 0;
    4:   FF := 0;
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= BIFC
procedure BIFC(IStep, N5: Integer;   QMOD: Double;   V: TV;   NKC: TArr3I;
               var BFX, BF1, BF2: TD);   Export;
  //--------------------------------------------------------------- Spec_begin
  var
    FFF: Double;
  //--------------------------------------------------------------- Spec_end
begin
  //--------------------------------------------------------------- Spec_begin
  if ISTEP = 0 then
  begin
    BFX[1] := 0;
    BF1[1] := V[1, 2];
    BF2[1] := 0;
  end
  else
  begin
    FFF := LN((SYM+1E0) * BI2 / BETA) / LN(10);
    BFX[IStep+1] := QMOD;   
    BF1[IStep+1] := V[1, 2];
    BF2[IStep+1] := FFF + LN(ABS((V[N5, 2] - 1)) / QMOD) / LN(10);
  end;
  //--------------------------------------------------------------- Spec_end
end;


//============================================================================= INAPP
procedure INAPP(N5, NDIM, INAP: Integer;   D : TD;   var V: TV);   Export;
var
  I : Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  if INAP = 3 then       //Non-standard setting of a grid D[I]:
  begin
    //------------------------------------------------------------- Spec_begin
    D[1]  := 0;
    // ...
    D[N5] := 1;
    //------------------------------------------------------------- Spec_end
  end;

  for I := 1 to N5 do    //Non-standard setting of a components V[I,J]:
  begin
    //------------------------------------------------------------- Spec_begin
    V[I, 1]    := 0;
    // ...
    V[I, NDIM] := 0;
    //------------------------------------------------------------- Spec_end
  end;
end;


//============================================================================= ADFUN
procedure ADFUN(N5: Integer;   QMOD: Double;   V: TV;   var WD: TV);   Export;
var
  I: Integer;
  //--------------------------------------------------------------- Spec_begin
  //--------------------------------------------------------------- Spec_end
begin
  for I := 1 to N5 do
  begin
    //------------------------------------------------------------- Spec_begin
    WD[I, 1] := 2 * V[I, 1];
    //------------------------------------------------------------- Spec_end
  end;
end;


Exports
  RENAM, BOND, LISTB, JACOB, LISTJ, BIFC, INAPP, ADFUN;


begin
end.
