library Special;

uses
  SysUtils, Classes, Math;
{$R *.RES}
type
  TD = array of Double;
  TV = array of array of Double;
  //````````````````````````````````````````````````````````````` <- Special
  var
    S0,S1,S2,S3,S4,S5,S6,  S12: Double;
  //````````````````````````````````````````````````````````````` <- Special
//-----------------------------------------------------------------------------
procedure Renam(SPar: TD);   Export;
var
  f28: TextFile;
begin
  //````````````````````````````````````````````````````````````` -> Special
  S0 := SPar[0];   S1 := SPar[1];   S2 := SPar[2];   S3 := SPar[3];
  S4 := SPar[4];   S5 := SPar[5];   S6 := SPar[6];
  S12 := S1 + S2;  
  //````````````````````````````````````````````````````````````` <- Special
  AssignFile(f28,'Param.rsl');   Append(f28);   writeln(f28,'  ');
  writeln(f28,'  : ');
  writeln(f28,'-------------------');
  //````````````````````````````````````````````````````````````` -> Special
  writeln(f28,'S0   = ',S0);
  writeln(f28,'S1   = ',S1);
  writeln(f28,'S2   = ',S2);
  writeln(f28,'S3   = ',S3);
  writeln(f28,'S4   = ',S4);
  writeln(f28,'S5   = ',S5);
  writeln(f28,'S6   = ',S6);
  //````````````````````````````````````````````````````````````` <- Special
  writeln(f28,'  ');
  writeln(f28,' : ');
  writeln(f28,'-------------');
  //````````````````````````````````````````````````````````````` -> Special
  writeln(f28,'S12   = ',S12);
  //````````````````````````````````````````````````````````````` <- Special
  CloseFile(f28);
end;
//-----------------------------------------------------------------------------
procedure Bond(NDIM,N2,N5: Integer;   V: TV;   SPar: TD;   var G: TV);   Export;
var
  K,J: Integer;
begin
  for K := 1 to NDIM do
    for J := 1 to N2+1 do   
      G[K,J] := 0.;
  //````````````````````````````````````````````````````````````` -> Special
      G[1,2] := 1.;   G[1,10] := V[1,2];
      G[2,3] := 1.;   G[2,10] := V[1,3];
      G[3,4] := 1.;   G[3,10] := V[1,4] - 1.;
      G[4,6] := 1.;   G[4,10] := V[N5,2];
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure BoList(L: Integer;   Z: TD;   SPar: TD;   var GG: Double);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  case L of
    1:   GG := Z[2];
    2:   GG := z[3];
    3:   GG := Z[4] - 1.;
    4:   GG := Z[6];
  end;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure Jacob(NDIM: Integer;   DI,DI1,DI2,QMOD: Double;   Q: TD;   SPar: TD;
                var O,R: TD;   var U: TV);   Export;
var
  K,J: Integer;
  //````````````````````````````````````````````````````````````` -> Special
  Z0,EE,WR,PP: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM+1 do   
      U[K,J] := 0.;
    R[K] := 0.;
  end;   //   K
  //````````````````````````````````````````````````````````````` -> Special
  Z0 := 1. / (1. + S6 * (S4 + abs(Q[1])));
  EE := exp(-(S4 + abs(Q[1])) * Z0);
  WR := 1. / (S5 + EE);
  PP := EE * sqr(WR * Z0);
  O[1] := Q[2];
    U[1,2] := 1.;
  O[2] := S0 * (S12 * Q[1] - S2 * Q[3] - QMOD * WR * Q[4]);
  R[2] := -S0 * WR * Q[4];
    U[2,1] := S0 * (S12 - QMOD * PP * Q[4]);
    U[2,3] := -S0 * S2;
    U[2,4] := -S0 * QMOD * WR;
  O[3] := S2 * (Q[1] - Q[3]);
    U[3,1] := S2;
    U[3,3] := -S2;
  O[4] := -S3 * WR * Q[4];
    U[4,1] := -S3 * PP * Q[4];
    U[4,4] := -S3 * WR;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure JaList(L: Integer;   DI,DI1,DI2: Double;   Z: TD;   SPar: TD;
                 var FF: Double);   Export;
  //````````````````````````````````````````````````````````````` -> Special
  var
    Z0,EE,WR: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  //````````````````````````````````````````````````````````````` -> Special
  Z0 := 1. / (1. + S6 * (S4 + Z[1]));
  EE := exp(-(S4 + Z[1]) * Z0);
  WR := 1. / (S5 + EE);
  case L of
    1:   FF := Z[2];
    2:   FF := S0 * (S12 * Z[1] - S2 * Z[3] - Z[5] * WR * Z[4]);
    3:   FF := S2 * (Z[1] - Z[3]);
    4:   FF := -S3 * WR * Z[4];
  end;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VYCHVD(N5: Integer;   QMOD: Double;   W1: TV;   SPar: TD;
                 var W1D: TV);   Export;
  //````````````````````````````````````````````````````````````` -> Special
  var
    I: Integer;
    Z0,EE,WR: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  //````````````````````````````````````````````````````````````` -> Special
    for I := 1 to N5 do
    begin
      Z0 := 1. / (1. + S6 * (S4 + abs(W1[I,1])));
      EE := exp(-(S4 + abs(W1[I,1])) * Z0);
      WR := 1. / (S5 + EE);
      W1D[I,1] := QMOD * WR * W1[I,4];
      W1D[I,2] := 0.5 * W1D[I,1];
    end;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VychBi(NDEL,IStep: Integer;   QMB: Double;   D: TD;
                 W1: TV;   SPar: TD;   var BFX,BF1,BF2: TD);   Export;
  //````````````````````````````````````````````````````````````` -> Special
  var
    i: Integer;
    sum,hh,zz: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  //````````````````````````````````````````````````````````````` -> Special
  sum := 0.;
  for i := 1 to Ndel do
  begin
    hh := 0.5 * (D[i+1] - D[i]);
    zz := hh * (W1[i,1] + W1[i+1,1] + hh/3. * (W1[i,2] - W1[i+1,2]));
    sum := sum + zz;
  end;   //   i
  BFX[IStep+1] := QMB;   BF1[IStep+1] := sum;   BF2[IStep+1] := W1[1,1];
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure InpNst(Iprd,NDIM: Integer;   var NDEL,N5,N6,I9,J9: Integer;
                 var D: TD;   var V: TV);   Export;
var
  I,J: Integer;
  f27,f3: TextFile;
begin
  //    D[I]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  //    V[I,J]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  if Iprd = 1 then
  begin
    AssignFile(f27,'Cont_.rsl');   Reset(f27);   readln(f27);
    AssignFile(f3, 'Check.rsl');   Reset(f3);    writeln(f3,'  ');
    writeln(f3,'  :');
    writeln(f3,'------------------');
    readln(f27,NDEL);    writeln(f3,'NDEL = ',NDEL);
    N5 := NDEL + 1;   N6 := 2 * N5;
    I9 := NDEL + 2;   J9 := 0;              // -  
    for I := 1 to N5 do
    begin
      readln(f27,D[I]);    writeln(f3,'I, D[I] = ',I,', ',D[I]);
    end;
    for I := 1 to N5 do
    begin
      writeln(f3,'I = ',I);
      for J := 1 to NDIM do
      begin
        readln(f27,V[I,J]);    writeln(f3,'J, V[I,J] = ',J,', ',V[I,J]);
      end;
    end;
    CloseFile(f27);   CloseFile(f3);
  end;
end;
//-----------------------------------------------------------------------------
Exports
  Renam  index 1,
  Bond   index 2,
  BoList index 3,
  Jacob  index 4,
  JaList index 5,
  VYCHVD index 6,
  VychBi index 7,
  InpNst index 8;
begin
end.
