library Special;

uses
  SysUtils, Classes;
{$R *.RES}
type
  TD = array of Double;
  TV = array of array of Double;
  //````````````````````````````````````````````````````````````` <- Special
  var
    ALFA,BETA: Double;
  //````````````````````````````````````````````````````````````` <- Special
//-----------------------------------------------------------------------------
procedure Renam(SPar: TD);   Export;
var
  f28: TextFile;
begin
  //````````````````````````````````````````````````````````````` -> Special
    ALFA := SPar[0];
    BETA := SPar[1];
  //````````````````````````````````````````````````````````````` <- Special
  AssignFile(f28,'Param.rsl');   Append(f28);   writeln(f28,'  ');
  writeln(f28,'  : ');
  writeln(f28,'-------------------');
  //````````````````````````````````````````````````````````````` -> Special
  writeln(f28,'ALFA = ',ALFA);
  writeln(f28,'BETA = ',BETA);
  //````````````````````````````````````````````````````````````` <- Special
  writeln(f28,'  ');
  writeln(f28,' : ');
  writeln(f28,'-------------');
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
  CloseFile(f28);
end;
//-----------------------------------------------------------------------------
procedure Bond(NDIM,N2,N5: Integer;   V: TV;   SPar: TD;   var G: TV);   Export;
var
  K,J: Integer;
begin
  for K := 1 to NDIM do
    for J := 1 to N2+1 do   
      G[K,J] := 0.;
  //````````````````````````````````````````````````````````````` -> Special
    G[1,2] := 1.;   G[1,N2+2] := V[1,2]; 
    G[2,3] := 1.;   G[2,N2+2] := V[N5,1];
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure BoList(L: Integer;   Z: TD;   SPar: TD;   var GG: Double);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure Jacob(NDIM: Integer;   DI,DI1,DI2,QMOD: Double;   Q: TD;   SPar: TD;
                var O,R: TD;   var U: TV);   Export;
var
  K,J: Integer;
  //````````````````````````````````````````````````````````````` -> Special
  ZZ,EX,WR: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM+1 do   
      U[K,J] := 0.;
    R[K] := 0.;
  end;   //   K
  //````````````````````````````````````````````````````````````` -> Special
    ZZ := 1E0 / (1E0 +  Q[1] / BETA);
    EX := exp(ZZ * Q[1]);
    WR := (ALFA - Q[1]) * EX;
    O[1] := Q[2];
    U[1,2] := 1E0;
    if abs(DI) > 1E-10 then
    begin
      O[2] := -2E0 * Q[2] / DI - QMOD * WR;
      U[2,1] := QMOD * EX * (1E0 - (ALFA - Q[1]) * ZZ * ZZ);
      U[2,2] := -2E0 / DI;
      R[2] := -WR
    end;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure JaList(L: Integer;   DI,DI1,DI2: Double;   Z: TD;   SPar: TD;
                 var FF: Double);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VYCHVD(N5: Integer;   QMOD: Double;   W1: TV;   SPar: TD;
                 var W1D: TV);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VychBi(NDEL,IStep: Integer;   QMB: Double;   D: TD;
                 W1: TV;   SPar: TD;   var BFX,BF1,BF2: TD);   Export;
  //````````````````````````````````````````````````````````````` -> Special
  var
    FACTOR: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  //````````````````````````````````````````````````````````````` -> Special
    BFX[IStep+1] := QMB;
    BF1[IStep+1] := W1[1,1];
    BF2[IStep+1] := 0.;
    if ISTEP > 0 then
    begin
      FACTOR := -3E0 * W1[NDEL+1,2] / ALFA / QMB;
      BF2[IStep+1] := Ln(FACTOR) / Ln(1E1);
    end;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure InpNst(Iprd,NDIM: Integer;   var NDEL,N5,N6,I9,J9: Integer;
                 var D: TD;   var V: TV);   Export;
var
  I,J: Integer;
  f27,f3: TextFile;
begin
  //    D[I]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  //    V[I,J]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  if Iprd = 1 then
  begin
    AssignFile(f27,'Cont_.rsl');   Reset(f27);   readln(f27);
    AssignFile(f3, 'Check.rsl');   Reset(f3);    writeln(f3,'  ');
    writeln(f3,'  :');
    writeln(f3,'------------------');
    readln(f27,NDEL);    writeln(f3,'NDEL = ',NDEL);
    N5 := NDEL + 1;   N6 := 2 * N5;
    I9 := NDEL + 2;   J9 := 0;              // -  
    for I := 1 to N5 do
    begin
      readln(f27,D[I]);    writeln(f3,'I, D[I] = ',I,', ',D[I]);
    end;
    for I := 1 to N5 do
    begin
      writeln(f3,'I = ',I);
      for J := 1 to NDIM do
      begin
        readln(f27,V[I,J]);    writeln(f3,'J, V[I,J] = ',J,', ',V[I,J]);
      end;
    end;
    CloseFile(f27);   CloseFile(f3);
  end;
end;
//-----------------------------------------------------------------------------
Exports
  Renam  index 1,
  Bond   index 2,
  BoList index 3,
  Jacob  index 4,
  JaList index 5,
  VYCHVD index 6,
  VychBi index 7,
  InpNst index 8;
begin
end.
