library Special;

uses
  SysUtils, Classes;
{$R *.RES}
type
  TD = array of Double;
  TV = array of array of Double;
  //````````````````````````````````````````````````````````````` <- Special
  var
    DPI: Double;
  //````````````````````````````````````````````````````````````` <- Special
//-----------------------------------------------------------------------------
procedure Renam(SPar: TD);   Export;
var
  f28: TextFile;
begin
  //````````````````````````````````````````````````````````````` -> Special
    DPI := SPar[0];
  //````````````````````````````````````````````````````````````` <- Special
  AssignFile(f28,'Param.rsl');   Append(f28);   writeln(f28,'  ');
  writeln(f28,'  : ');
  writeln(f28,'-------------------');
  //````````````````````````````````````````````````````````````` -> Special
  writeln(f28,'DPI = ',DPI);
  //````````````````````````````````````````````````````````````` <- Special
  writeln(f28,'  ');
  writeln(f28,' : ');
  writeln(f28,'-------------');
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
  CloseFile(f28);
end;
//-----------------------------------------------------------------------------
procedure Bond(NDIM,N2,N5: Integer;   V: TV;   SPar: TD;   var G: TV);   Export;
var
  K,J: Integer;
begin
  for K := 1 to NDIM do
    for J := 1 to N2+1 do
      G[K,J] := 0.;
  //````````````````````````````````````````````````````````````` -> Special
    for K := 1 to NDIM-1 do
    begin
      G[K,K] := 1.;
      G[K,K+NDIM] := -1.;
      G[K,N2+2] := V[1,K]-V[N5,K];
    end;
    G[3,2] := 1.;
    G[3,N2+2] := V[1, 2];
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure BoList(L: Integer;   Z: TD;   SPar: TD;   var GG: Double);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure Jacob(NDIM: Integer;   DI,DI1,DI2,QMOD: Double;   Q: TD;   SPar: TD;
                var O,R: TD;   var U: TV);   Export;
var
  K,J: Integer;
  //````````````````````````````````````````````````````````````` -> Special
  ZZ: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM+1 do
      U[K,J] := 0.;
    R[K] := 0.;
  end;   //   K
  //````````````````````````````````````````````````````````````` -> Special
    O[1] := Q[3]*Q[2];
     U[1,2] := Q[3];
     U[1,3] := Q[2];
     ZZ := (1.- Q[1])*(1.+Q[1]);
     U[2,3] := -Q[1]+QMOD*Q[2]*ZZ;
    O[2] := Q[3]*U[2,3];
    R[2] := Q[3]*Q[2]*ZZ;
     U[2,1] := -Q[3]*(1.+2.*QMOD*Q[1]*Q[2]);
     U[2,2] :=  Q[3]*QMOD*ZZ;
    O[3] := 0;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure JaList(L: Integer;   DI,DI1,DI2: Double;   Z: TD;   SPar: TD;
                 var FF: Double);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VYCHVD(N5: Integer;   QMOD: Double;   W1: TV;   SPar: TD;
                 var W1D: TV);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VychBi(NDEL,IStep: Integer;   QMB: Double;   D: TD;
                 W1: TV;   SPar: TD;   var BFX,BF1,BF2: TD);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
    BFX[IStep+1] := QMB;
    BF1[IStep+1] := W1[1,3];
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure InpNst(Iprd,NDIM: Integer;   var NDEL,N5,N6,I9,J9: Integer;
                 var D: TD;   var V: TV);   Export;
var
  I,J: Integer;
  f27,f3: TextFile;
begin
  //    D[I]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  //    V[I,J]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  if Iprd = 1 then
  begin
    AssignFile(f27,'Cont_.rsl');   Reset(f27);   readln(f27);
    AssignFile(f3, 'Check.rsl');   Reset(f3);    writeln(f3,'  ');
    writeln(f3,'  :');
    writeln(f3,'------------------');
    readln(f27,NDEL);    writeln(f3,'NDEL = ',NDEL);
    N5 := NDEL + 1;   N6 := 2 * N5;
    I9 := NDEL + 2;   J9 := 0;              // -  
    for I := 1 to N5 do
    begin
      readln(f27,D[I]);    writeln(f3,'I, D[I] = ',I,', ',D[I]);
    end;
    for I := 1 to N5 do
    begin
      writeln(f3,'I = ',I);
      for J := 1 to NDIM do
      begin
        readln(f27,V[I,J]);    writeln(f3,'J, V[I,J] = ',J,', ',V[I,J]);
      end;
    end;
    CloseFile(f27);   CloseFile(f3);
  end;
    for I := 1 to N5 do
    begin
      V[I,1] :=  2.*cos(DPI*D[I]);
      V[I,2] := -2.*DPI*sin(DPI*D[I]);
      V[I,3] := DPI;
    end;
end;
//-----------------------------------------------------------------------------
Exports
  Renam  index 1,
  Bond   index 2,
  BoList index 3,
  Jacob  index 4,
  JaList index 5,
  VYCHVD index 6,
  VychBi index 7,
  InpNst index 8;
begin
end.
