library Special;

uses
  SysUtils, Classes, Math;
{$R *.RES}
type
  TD = array of Double;
  TV = array of array of Double;
  //````````````````````````````````````````````````````````````` <- Special
  var
    Y01,Y02,BI1,BI2,SYM,BETA,GAMA,DEGR,RZ: Double;
  //````````````````````````````````````````````````````````````` <- Special
//-----------------------------------------------------------------------------
procedure Renam(SPar: TD);   Export;
var
  f28: TextFile;
begin
  //````````````````````````````````````````````````````````````` -> Special
  Y01 := SPar[0];   Y02  := SPar[1];   BI1  := SPar[2];   BI2  := SPar[3];
  SYM := SPar[4];   BETA := SPar[5];   GAMA := SPar[6];   DEGR := SPar[7];
  RZ  := SPar[8];
  //````````````````````````````````````````````````````````````` <- Special
  AssignFile(f28,'Param.rsl');   Append(f28);   writeln(f28,'  ');
  writeln(f28,'  : ');
  writeln(f28,'-------------------');
  //````````````````````````````````````````````````````````````` -> Special
  writeln(f28,'Y01  = ',Y01 );
  writeln(f28,'Y02  = ',Y02 );
  writeln(f28,'BI1  = ',BI1 );
  writeln(f28,'BI2  = ',BI2 );
  writeln(f28,'SYM  = ',SYM );
  writeln(f28,'BETA = ',BETA);
  writeln(f28,'GAMA = ',GAMA);
  writeln(f28,'DEGR = ',DEGR);
  writeln(f28,'RZ   = ',RZ  );
  //````````````````````````````````````````````````````````````` <- Special
  writeln(f28,'  ');
  writeln(f28,' : ');
  writeln(f28,'-------------');
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
  CloseFile(f28);
end;
//-----------------------------------------------------------------------------
procedure Bond(NDIM,N2,N5: Integer;   V: TV;   SPar: TD;   var G: TV);   Export;
var
  K,J: Integer;
begin
  for K := 1 to NDIM do
    for J := 1 to N2+1 do
      G[K,J] := 0.;
  //````````````````````````````````````````````````````````````` -> Special
  for K := 1 to 2 do
  begin
    G[K,N2+2]       := V[1,K+2];
    G[K+2,N2+2]     := V[N5,K+2]-RZ*Spar[K+1]*(Spar[K-1]-V[N5,K]);
    G[K,K+2]        := 1E0;
    G[K+2,K+NDIM]   := RZ*Spar[K+1];
    G[K+2,K+2+NDIM] := 1E0;
  end;  
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure BoList(L: Integer;   Z: TD;   SPar: TD;   var GG: Double);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure Jacob(NDIM: Integer;   DI,DI1,DI2,QMOD: Double;   Q: TD;   SPar: TD;
                var O,R: TD;   var U: TV);   Export;
var
  K,J: Integer;
  //````````````````````````````````````````````````````````````` -> Special
var
  EE,WW,W1,W2: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  for K := 1 to NDIM do
  begin
    for J := 1 to NDIM+1 do
      U[K,J] := 0.;
    R[K] := 0.;
  end;   //   K
  //````````````````````````````````````````````````````````````` -> Special
  for K := 1 to 2 do
  begin
    O[K] := Q[K+2];
    U[K,K+2] := 1E0;
  end;
  EE := EXP(GAMA * (1E0 - 1E0 / Q[2]));
  WW := Power(Q[1],DEGR) *EE;
  W1 := DEGR * Power(Q[1],DEGR-1E0) * EE;
  W2 := GAMA * WW / (Q[2] * Q[2]);
  O[3] := QMOD * WW;
  U[3, 1] := QMOD * W1;
  U[3, 2] := QMOD * W2;
  R[3] := WW;
  O[4] := -BETA * O[3];
  U[4, 1] := -BETA * U[3, 1];
  U[4, 2] := -BETA * U[3, 2];
  R[4] := -BETA * R[3];
  if ABS(DI) < 1E-5 then
    for K := 1 to 2 do
    begin
      for J := 1 to 2 do
        U[K+2,J] := U[K+2,J] / (SYM+1E0);
      O[K+2] := O[K+2] / (SYM+1E0);
      R[K+2] := R[K+2] / (SYM+1E0);
    end
  else
  for K := 1 to 2 do
  begin
    O[K+2] := O[K+2] - SYM * Q[K+2] / DI;
    U[K+2,K+2] := -SYM / DI;
    U[K+2,NDIM+1] := SYM * Q[K+2] / (DI * DI);
  end;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure JaList(L: Integer;   DI,DI1,DI2: Double;   Z: TD;   SPar: TD;
                 var FF: Double);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VYCHVD(N5: Integer;   QMOD: Double;   W1: TV;   SPar: TD;
                 var W1D: TV);   Export;
begin
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure VychBi(NDEL,IStep: Integer;   QMB: Double;   D: TD;
                 W1: TV;   SPar: TD;   var BFX,BF1,BF2: TD);   Export;
  //````````````````````````````````````````````````````````````` -> Special
  var
    FFF: Double;
  //````````````````````````````````````````````````````````````` <- Special
begin
  //````````````````````````````````````````````````````````````` -> Special
  if ISTEP = 0 then
  begin
    BFX[1] := 0;
    BF1[1] := W1[1, 2];
    BF2[1] := 0;
  end
  else
  begin
    FFF := LN((SYM+1E0) * BI2 / BETA) / LN(10);
    BFX[IStep+1] := QMB;   BF1[IStep+1] := W1[1, 2];
    BF2[IStep+1] := FFF + LN(ABS((W1[NDEL+1, 2] - 1)) / QMB) / LN(10);
  end;
  //````````````````````````````````````````````````````````````` <- Special
end;
//-----------------------------------------------------------------------------
procedure InpNst(Iprd,NDIM: Integer;   SPar: TD;
                 var NDEL,N5,N6,I9,J9: Integer;   var D: TD;   var V: TV);   Export;
var
  I,J: Integer;
  f27,f3: TextFile;
begin
  //    D[I]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  //    V[I,J]:
  //````````````````````````````````````````````````````````````` -> Special
  //````````````````````````````````````````````````````````````` <- Special

  if Iprd = 1 then
  begin
    AssignFile(f27,'Cont_.rsl');   Reset(f27);   readln(f27);
    AssignFile(f3, 'Check.rsl');   Reset(f3);    writeln(f3,'  ');
    writeln(f3,'  :');
    writeln(f3,'------------------');
    readln(f27,NDEL);    writeln(f3,'NDEL = ',NDEL);
    N5 := NDEL + 1;   N6 := 2 * N5;
    I9 := NDEL + 2;   J9 := 0;              // -  
    for I := 1 to N5 do
    begin
      readln(f27,D[I]);    writeln(f3,'I, D[I] = ',I,', ',D[I]);
    end;
    for I := 1 to N5 do
    begin
      writeln(f3,'I = ',I);
      for J := 1 to NDIM do
      begin
        readln(f27,V[I,J]);    writeln(f3,'J, V[I,J] = ',J,', ',V[I,J]);
      end;
    end;
    CloseFile(f27);   CloseFile(f3);
  end;
end;
//-----------------------------------------------------------------------------
Exports
  Renam  ,//index 1,
  Bond   ,//index 2,
  BoList ,//index 3,
  Jacob  ,//index 4,
  JaList ,//index 5,
  VYCHVD ,//index 6,
  VychBi ,//index 7,
  InpNst ;//index 8;
begin
end.
